/*
 * Copyright (C) 2005-2010 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */
package org.alfresco.repo.audit.generator;

import java.io.Serializable;

import org.alfresco.repo.transaction.AlfrescoTransactionSupport;

/**
 * Gives back the currently transaction ID.
 * 
 * @author Derek Hulley
 * @since 3.2
 */
public class TransactionIdDataGenerator extends AbstractDataGenerator
{
    /**
     * @return              Returns the current transaction ID (<tt>null</tt> if not in a transction)
     */
    public Serializable getData() throws Throwable
    {
        return AlfrescoTransactionSupport.getTransactionId();
    }
}
