/*
 * Copyright (C) 2005-2010 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */
package org.alfresco.repo.avm;

import org.alfresco.service.cmr.repository.ContentData;

/**
 * Interface for Plain file nodes.
 * @author britt
 */
public interface PlainFileNode extends FileNode
{
    public ContentData getContentData();
    public void setContentData(ContentData contentData);
    
    public boolean isLegacyContentData();
    public Long getContentDataId();
    
    /**
     * DAO accessor only.  <b>DO NOT USE</b> in code.
     */
    public String getContentURL();
    /**
     * DAO accessor only.  <b>DO NOT USE</b> in code.
     */
    public String getMimeType();
    /**
     * DAO accessor only.  <b>DO NOT USE</b> in code.
     */
    public String getEncoding();
    /**
     * DAO accessor only.  <b>DO NOT USE</b> in code.
     */
    public long getLength();
}
