/*
 * Copyright (C) 2005-2010 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */
package org.alfresco.repo.domain.query;

import org.alfresco.error.AlfrescoRuntimeException;

/**
 * Exception generated by failures to execute canned queries.
 * 
 * @author Derek Hulley
 * @since 3.5
 */
public class QueryException extends AlfrescoRuntimeException
{
    private static final long serialVersionUID = -7827116537885580234L;

    /**
     * @param msg           the message
     */
    public QueryException(String msg)
    {
        super(msg);
    }

    /**
     * @param msg           the message
     * @param cause         the exception cause
     */
    public QueryException(String msg, Throwable cause)
    {
        super(msg, cause);
    }

    /**
     * Constructor
     * 
     * @param msgId         the message id
     * @param msgParams     the message parameters
     */
    public QueryException(String msgId, Object[] msgParams)
    {
        super(msgId, msgParams);
    }

    /**
     * Constructor
     * 
     * @param msgId         the message id
     * @param msgParams     the message parameters
     * @param cause         the exception cause
     */
    public QueryException(String msgId, Object[] msgParams, Throwable cause)
    {
        super(msgId, msgParams, cause);
    }
}
