/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.ParameterCheck;

public class M2ModelDiff {
    public static final String DIFF_CREATED = "created";
    public static final String DIFF_UPDATED = "updated";
    public static final String DIFF_UPDATED_INC = "updated_inc";
    public static final String DIFF_DELETED = "deleted";
    public static final String DIFF_UNCHANGED = "unchanged";
    public static final String TYPE_TYPE = "TYPE";
    public static final String TYPE_ASPECT = "ASPECT";
    public static final String TYPE_DEFAULT_ASPECT = "DEFAULT_ASPECT";
    public static final String TYPE_PROPERTY = "PROPERTY";
    public static final String TYPE_ASSOCIATION = "ASSOCIATION";
    public static final String TYPE_CONSTRAINT = "TYPE_CONSTRAINT";
    private QName elementName;
    private String elementType;
    private String diffType;

    public M2ModelDiff(QName elementName, String elementType, String diffType) {
        ParameterCheck.mandatory((String)"elementName", (Object)elementName);
        ParameterCheck.mandatoryString((String)"elementType", (String)elementType);
        ParameterCheck.mandatoryString((String)"diffType", (String)diffType);
        if (!(elementType.equals(TYPE_TYPE) || elementType.equals(TYPE_ASPECT) || elementType.equals(TYPE_DEFAULT_ASPECT) || elementType.equals(TYPE_PROPERTY) || elementType.equals(TYPE_ASSOCIATION) || elementType.equals(TYPE_CONSTRAINT))) {
            throw new AlfrescoRuntimeException("Unknown element type = " + elementType);
        }
        if (!(diffType.equals(DIFF_CREATED) || diffType.equals(DIFF_UPDATED) || diffType.equals(DIFF_UPDATED_INC) || diffType.equals(DIFF_DELETED) || diffType.equals(DIFF_UNCHANGED))) {
            throw new AlfrescoRuntimeException("Unknown diff type = " + diffType);
        }
        this.elementName = elementName;
        this.elementType = elementType;
        this.diffType = diffType;
    }

    public QName getElementName() {
        return this.elementName;
    }

    public String getElementType() {
        return this.elementType;
    }

    public String getDiffType() {
        return this.diffType;
    }

    public String toString() {
        return new String(this.elementType + " " + this.elementName + " " + this.diffType);
    }
}

