/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.AbstractAnalyzer;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.analysis.AlfrescoStandardAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.LongAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.MLAnalayser;
import org.alfresco.repo.search.impl.lucene.analysis.PathAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.VerbatimAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.VerbatimMLAnalayser;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;

public class LuceneAnalyser
extends AbstractAnalyzer {
    private static Log s_logger = LogFactory.getLog(LuceneAnalyser.class);
    private DictionaryService dictionaryService;
    private Analyzer defaultAnalyser;
    private Map<String, Analyzer> analysers = new HashMap<String, Analyzer>();
    private MLAnalysisMode mlAlaysisMode;

    public LuceneAnalyser(DictionaryService dictionaryService, MLAnalysisMode mlAlaysisMode) {
        this.defaultAnalyser = new AlfrescoStandardAnalyser();
        this.dictionaryService = dictionaryService;
        this.mlAlaysisMode = mlAlaysisMode;
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader, AnalysisMode analysisMode) {
        Analyzer analyser = this.analysers.get(fieldName);
        if (analyser == null) {
            analyser = this.findAnalyser(fieldName, analysisMode);
        }
        return analyser.tokenStream(fieldName, reader);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return this.tokenStream(fieldName, reader, AnalysisMode.DEFAULT);
    }

    private Analyzer findAnalyser(String fieldName, AnalysisMode analysisMode) {
        Analyzer analyser;
        if (fieldName.equals("ID")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("LEAFID")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("DBID")) {
            analyser = new LongAnalyser();
        } else if (fieldName.equals("TXID")) {
            analyser = new LongAnalyser();
        } else if (fieldName.equals("ACLTXID")) {
            analyser = new LongAnalyser();
        } else if (fieldName.equals("TXCOMMITTIME")) {
            analyser = new LongAnalyser();
        } else if (fieldName.equals("ACLTXCOMMITTIME")) {
            analyser = new LongAnalyser();
        } else if (fieldName.equals("ACLID")) {
            analyser = new LongAnalyser();
        } else if (fieldName.equals("TX")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("PARENT")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("LINKASPECT")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("PATH")) {
            analyser = new PathAnalyser();
        } else if (fieldName.equals("ANCESTOR")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("ISCONTAINER")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("READER")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("OWNER")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("ISCATEGORY")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("QNAME")) {
            analyser = new PathAnalyser();
        } else if (fieldName.equals("ISROOT")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("PRIMARYASSOCTYPEQNAME")) {
            analyser = new PathAnalyser();
        } else if (fieldName.equals("ISNODE")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("ASSOCTYPEQNAME")) {
            analyser = new PathAnalyser();
        } else if (fieldName.equals("PRIMARYPARENT")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("TYPE")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("ASPECT")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("FTSSTATUS")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.equals("FTSREF")) {
            analyser = new VerbatimAnalyser(false);
        } else if (fieldName.startsWith("@")) {
            if (fieldName.endsWith(".mimetype")) {
                analyser = new VerbatimAnalyser();
            } else if (fieldName.endsWith(".size")) {
                analyser = new LongAnalyser();
            } else if (fieldName.endsWith(".locale")) {
                analyser = new VerbatimAnalyser(true);
            } else {
                QName propertyQName = QName.createQName(fieldName.substring(1));
                if (propertyQName.equals(ContentModel.PROP_USER_USERNAME) || propertyQName.equals(ContentModel.PROP_USERNAME) || propertyQName.equals(ContentModel.PROP_AUTHORITY_NAME)) {
                    analyser = new VerbatimAnalyser(true);
                } else {
                    PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
                    IndexTokenisationMode tokenise = IndexTokenisationMode.TRUE;
                    if (propertyDef != null) {
                        DataTypeDefinition dataType = propertyDef.getDataType();
                        tokenise = propertyDef.getIndexTokenisationMode();
                        if (tokenise == null) {
                            tokenise = IndexTokenisationMode.TRUE;
                        }
                        block0 : switch (tokenise) {
                            case TRUE: {
                                if (dataType.getName().equals(DataTypeDefinition.CONTENT)) {
                                    analyser = new MLAnalayser(this.dictionaryService, MLAnalysisMode.ALL_ONLY);
                                    break;
                                }
                                if (dataType.getName().equals(DataTypeDefinition.TEXT)) {
                                    analyser = new MLAnalayser(this.dictionaryService, MLAnalysisMode.ALL_ONLY);
                                    break;
                                }
                                if (dataType.getName().equals(DataTypeDefinition.MLTEXT)) {
                                    analyser = new MLAnalayser(this.dictionaryService, this.mlAlaysisMode);
                                    break;
                                }
                                analyser = this.loadAnalyzer(propertyDef);
                                break;
                            }
                            case BOTH: {
                                switch (analysisMode) {
                                    case DEFAULT: 
                                    case TOKENISE: 
                                    case WILD: 
                                    case PREFIX: {
                                        if (dataType.getName().equals(DataTypeDefinition.CONTENT)) {
                                            analyser = new MLAnalayser(this.dictionaryService, MLAnalysisMode.ALL_ONLY);
                                            break block0;
                                        }
                                        if (dataType.getName().equals(DataTypeDefinition.TEXT)) {
                                            analyser = new MLAnalayser(this.dictionaryService, MLAnalysisMode.ALL_ONLY);
                                            break block0;
                                        }
                                        if (dataType.getName().equals(DataTypeDefinition.MLTEXT)) {
                                            analyser = new MLAnalayser(this.dictionaryService, this.mlAlaysisMode);
                                            break block0;
                                        }
                                        analyser = this.loadAnalyzer(propertyDef);
                                        break block0;
                                    }
                                    case IDENTIFIER: 
                                    case LIKE: {
                                        if (dataType.getName().equals(DataTypeDefinition.MLTEXT)) {
                                            analyser = new VerbatimMLAnalayser(this.mlAlaysisMode);
                                            break block0;
                                        }
                                        analyser = new VerbatimAnalyser();
                                        break block0;
                                    }
                                }
                                throw new UnsupportedOperationException("TYPE must not be tokenised");
                            }
                            case FALSE: {
                                analyser = new VerbatimAnalyser();
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("TYPE must not be tokenised");
                            }
                        }
                    } else {
                        switch (analysisMode) {
                            case IDENTIFIER: 
                            case LIKE: {
                                analyser = new VerbatimAnalyser();
                                break;
                            }
                            case DEFAULT: 
                            case TOKENISE: 
                            case WILD: 
                            case PREFIX: {
                                DataTypeDefinition dataType = this.dictionaryService.getDataType(DataTypeDefinition.TEXT);
                                analyser = this.loadAnalyzer(dataType);
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException();
                            }
                        }
                    }
                }
            }
        } else {
            analyser = this.defaultAnalyser;
        }
        this.analysers.put(fieldName, analyser);
        return analyser;
    }

    private Analyzer loadAnalyzer(PropertyDefinition propertyDef) {
        String analyserClassName = propertyDef.resolveAnalyserClassName().trim();
        try {
            Class<?> clazz = Class.forName(analyserClassName);
            Analyzer analyser = (Analyzer)clazz.newInstance();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Loaded " + analyserClassName + " for type " + propertyDef.getName()));
            }
            return analyser;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + propertyDef.getName() + " using " + analyserClassName);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + propertyDef.getName() + " using " + analyserClassName);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + propertyDef.getName() + " using " + analyserClassName);
        }
    }

    private Analyzer loadAnalyzer(DataTypeDefinition dataTypeDef) {
        String analyserClassName = dataTypeDef.resolveAnalyserClassName().trim();
        try {
            Class<?> clazz = Class.forName(analyserClassName);
            Analyzer analyser = (Analyzer)clazz.newInstance();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Loaded " + analyserClassName + " for type " + dataTypeDef.getName()));
            }
            return analyser;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + dataTypeDef.getName() + " using " + analyserClassName);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + dataTypeDef.getName() + " using " + analyserClassName);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + dataTypeDef.getName() + " using " + analyserClassName);
        }
    }

    public int getPositionIncrementGap(String fieldName) {
        QName propertyQName;
        PropertyDefinition propertyDef;
        if (fieldName.startsWith("@") && !fieldName.endsWith(".mimetype") && (propertyDef = this.dictionaryService.getProperty(propertyQName = QName.createQName(fieldName.substring(1)))) != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.MLTEXT)) {
            return 1000;
        }
        return super.getPositionIncrementGap(fieldName);
    }
}

