/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;

public class LuceneUtils {
    private static final SimpleDateFormat LUCENE_DATETIME_FORMAT = new SimpleDateFormat("yyyy\\-MM\\-dd'T'HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean fieldHasTerm(IndexReader indexReader, String field) {
        try (TermEnum termEnum = indexReader.terms(new Term(field, ""));){
            if (termEnum.next()) {
                Term first = termEnum.term();
                boolean bl = first.field().equals(field);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Could not find terms for sort field ", (Throwable)e);
        }
    }

    public static String getLuceneDateString(Date date) {
        return LUCENE_DATETIME_FORMAT.format(date);
    }

    public static String createDateRangeQuery(Date fromDate, Date toDate, QName dateProperty, DictionaryService dictionaryService, NamespaceService namespaceService) {
        if (dateProperty == null) {
            throw new NullPointerException("dateProperty cannot be null");
        }
        PropertyDefinition propDef = dictionaryService.getProperty(dateProperty);
        if (propDef == null) {
            throw new NullPointerException("dateProperty '" + dateProperty + "' not recognised.");
        }
        QName propDefType = propDef.getDataType().getName();
        if (!DataTypeDefinition.DATE.equals(propDefType) && !DataTypeDefinition.DATETIME.equals(propDefType)) {
            throw new IllegalArgumentException("Illegal property type '" + dateProperty + "' [" + propDefType + "]");
        }
        QName propertyName = propDef.getName();
        String shortFormQName = propertyName.toPrefixString(namespaceService);
        String prefix = shortFormQName.substring(0, shortFormQName.indexOf(58));
        String localName = propertyName.getLocalName();
        String ZERO_DATE = "1970\\-01\\-01T00:00:00";
        String FUTURE_DATE = "3000\\-12\\-31T00:00:00";
        StringBuilder luceneQuery = new StringBuilder();
        luceneQuery.append(" +@").append(prefix).append("\\:").append(localName).append(":[");
        if (fromDate != null) {
            luceneQuery.append(LuceneUtils.getLuceneDateString(fromDate));
        } else {
            luceneQuery.append("1970\\-01\\-01T00:00:00");
        }
        luceneQuery.append(" TO ");
        if (toDate != null) {
            luceneQuery.append(LuceneUtils.getLuceneDateString(toDate));
        } else {
            luceneQuery.append("3000\\-12\\-31T00:00:00");
        }
        luceneQuery.append("] ");
        return luceneQuery.toString();
    }
}

