/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.alfresco.repo.search.impl.lucene.analysis.NumericEncoder;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WhitespaceTokenizer;

public class LongTokenFilter
extends Tokenizer {
    Tokenizer baseTokeniser;

    public LongTokenFilter(Reader in) {
        super(in);
        this.baseTokeniser = new WhitespaceTokenizer(in);
    }

    public Token next() throws IOException {
        Token candidate;
        while ((candidate = this.baseTokeniser.next()) != null) {
            try {
                Long longValue = Long.valueOf(candidate.termText());
                String valueString = NumericEncoder.encode(longValue);
                Token longToken = new Token(valueString, candidate.startOffset(), candidate.startOffset(), candidate.type());
                return longToken;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return null;
    }
}

