/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.query;

import java.io.IOException;
import org.alfresco.repo.search.impl.lucene.query.AbstractStructuredFieldPosition;

public class AbsoluteStructuredFieldPosition
extends AbstractStructuredFieldPosition {
    int requiredPosition;

    public AbsoluteStructuredFieldPosition(String termText, int position) {
        super(termText, true, true);
        this.requiredPosition = position;
    }

    @Override
    public int matches(int start, int end, int offset) throws IOException {
        if (offset >= this.requiredPosition) {
            return -1;
        }
        if (this.getCachingTermPositions() != null) {
            this.getCachingTermPositions().reset();
            int count = this.getCachingTermPositions().freq();
            int realPosition = 0;
            int adjustedPosition = 0;
            for (int i = 0; i < count; ++i) {
                realPosition = this.getCachingTermPositions().nextPosition();
                adjustedPosition = realPosition - start;
                if (end != -1 && realPosition > end) {
                    return -1;
                }
                if (adjustedPosition > this.requiredPosition) {
                    return -1;
                }
                if (adjustedPosition != this.requiredPosition) continue;
                return adjustedPosition;
            }
        } else if (offset + 1 == this.requiredPosition) {
            return offset + 1;
        }
        return -1;
    }

    @Override
    public int getPosition() {
        return this.requiredPosition;
    }

    @Override
    public String getDescription() {
        return "Absolute Named child";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.requiredPosition;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbsoluteStructuredFieldPosition other = (AbsoluteStructuredFieldPosition)obj;
        return this.requiredPosition == other.requiredPosition;
    }
}

