/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import java.io.Serializable;
import org.alfresco.cmis.CMISDictionaryModel;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.mapping.CMISMapping;
import org.alfresco.service.namespace.QName;

public class CMISTypeId
implements Serializable {
    private static final long serialVersionUID = -4709046883083948302L;
    private CMISScope scope;
    private QName typeQName;
    private String typeId;
    private QName internalQName;

    public CMISTypeId(CMISScope scope, QName typeQName, String typeId, QName internalQName) {
        this.scope = scope;
        this.typeQName = typeQName;
        this.typeId = typeId;
        this.internalQName = internalQName;
    }

    public String getId() {
        return this.typeId;
    }

    public String getLocalName() {
        return this.typeQName.getLocalName();
    }

    public String getLocalNamespace() {
        return this.typeQName.getNamespaceURI();
    }

    public CMISScope getScope() {
        return this.scope;
    }

    public QName getQName() {
        return this.internalQName;
    }

    public CMISTypeId getBaseTypeId() {
        switch (this.scope) {
            case DOCUMENT: {
                return CMISDictionaryModel.DOCUMENT_TYPE_ID;
            }
            case FOLDER: {
                return CMISDictionaryModel.FOLDER_TYPE_ID;
            }
            case RELATIONSHIP: {
                return CMISDictionaryModel.RELATIONSHIP_TYPE_ID;
            }
            case POLICY: {
                return CMISDictionaryModel.POLICY_TYPE_ID;
            }
            case OBJECT: {
                return CMISMapping.OBJECT_TYPE_ID;
            }
        }
        return null;
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.typeId == null ? 0 : this.typeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CMISTypeId other = (CMISTypeId)obj;
        return !(this.typeQName == null ? other.typeQName != null : !this.typeQName.equals((Object)other.typeQName));
    }
}

