/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.acl;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.cmis.CMISAccessControlEntriesGroupedByPrincipalId;
import org.alfresco.cmis.CMISAccessControlEntry;
import org.alfresco.cmis.CMISConstraintException;

public class CMISAccessControlEntriesGroupedByPrincipalIdImpl
implements CMISAccessControlEntriesGroupedByPrincipalId {
    private String principalId;
    private List<String> directPermissions = new ArrayList<String>();
    private List<String> indirectPermissions = new ArrayList<String>();

    CMISAccessControlEntriesGroupedByPrincipalIdImpl(String principalId) {
        this.principalId = principalId;
    }

    @Override
    public List<String> getDirectPermissions() {
        return this.directPermissions;
    }

    @Override
    public List<String> getIndirectPermissions() {
        return this.indirectPermissions;
    }

    @Override
    public String getPrincipalId() {
        return this.principalId;
    }

    void addEntry(CMISAccessControlEntry entry) throws CMISConstraintException {
        if (!this.principalId.equals(entry.getPrincipalId())) {
            throw new CMISConstraintException("Grouping error in principal id");
        }
        if (entry.getDirect()) {
            this.directPermissions.add(entry.getPermission());
        } else {
            this.indirectPermissions.add(entry.getPermission());
        }
    }
}

