/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.acl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.cmis.CMISAccessControlEntriesGroupedByPrincipalId;
import org.alfresco.cmis.CMISAccessControlEntry;
import org.alfresco.cmis.CMISAccessControlReport;
import org.alfresco.cmis.CMISConstraintException;
import org.alfresco.cmis.acl.CMISAccessControlEntriesGroupedByPrincipalIdImpl;

public class CMISAccessControlReportImpl
implements CMISAccessControlReport {
    private ArrayList<CMISAccessControlEntry> entries = new ArrayList();
    private boolean extract = false;

    public List<CMISAccessControlEntry> getAccessControlEntries() {
        return this.entries;
    }

    @Override
    public boolean isExact() {
        return this.extract;
    }

    public void setExtract(boolean extract) {
        this.extract = extract;
    }

    void addEntry(CMISAccessControlEntry entry) {
        this.removeEntry(entry);
        this.entries.add(entry);
    }

    void removeEntry(CMISAccessControlEntry entry) {
        for (int i = 0; i < this.entries.size(); ++i) {
            CMISAccessControlEntry current = this.entries.get(i);
            if (!current.getPrincipalId().equals(entry.getPrincipalId()) || !current.getPermission().equals(entry.getPermission())) continue;
            this.entries.remove(i);
            --i;
        }
    }

    @Override
    public List<? extends CMISAccessControlEntriesGroupedByPrincipalId> getAccessControlEntriesGroupedByPrincipalId() throws CMISConstraintException {
        HashMap<String, CMISAccessControlEntriesGroupedByPrincipalIdImpl> grouped = new HashMap<String, CMISAccessControlEntriesGroupedByPrincipalIdImpl>();
        for (CMISAccessControlEntry entry : this.getAccessControlEntries()) {
            CMISAccessControlEntriesGroupedByPrincipalIdImpl value = (CMISAccessControlEntriesGroupedByPrincipalIdImpl)grouped.get(entry.getPrincipalId());
            if (value == null) {
                value = new CMISAccessControlEntriesGroupedByPrincipalIdImpl(entry.getPrincipalId());
                grouped.put(entry.getPrincipalId(), value);
            }
            value.addEntry(entry);
        }
        ArrayList answer = new ArrayList(grouped.values());
        return answer;
    }
}

