/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import org.alfresco.cmis.CMISAllowedActionEnum;
import org.alfresco.cmis.mapping.AbstractActionEvaluator;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class AspectActionEvaluator<ObjectType>
extends AbstractActionEvaluator<ObjectType> {
    private NodeService nodeService;
    private boolean expected;
    private boolean allAspectsMustConcur;
    private boolean defaultAllowing;
    private QName[] aspects;

    public AspectActionEvaluator(ServiceRegistry serviceRegistry, CMISAllowedActionEnum action, boolean expected, boolean allAspectsMustConcur, boolean defaultAllowing, QName ... aspects) {
        super(serviceRegistry, action);
        this.expected = expected;
        this.allAspectsMustConcur = allAspectsMustConcur;
        this.aspects = aspects;
        this.nodeService = serviceRegistry.getNodeService();
    }

    @Override
    public boolean isAllowed(ObjectType id) {
        NodeRef nodeRef;
        NodeRef nodeRef2 = nodeRef = id instanceof NodeRef ? (NodeRef)id : null;
        if (null != nodeRef && null != this.aspects) {
            for (QName aspectId : this.aspects) {
                boolean aspect = this.nodeService.hasAspect(nodeRef, aspectId);
                if (!this.expected) {
                    boolean bl = aspect = !aspect;
                }
                if (!this.allAspectsMustConcur && aspect) {
                    return true;
                }
                if (!this.allAspectsMustConcur || aspect) continue;
                return false;
            }
            return this.allAspectsMustConcur;
        }
        return this.defaultAllowing;
    }
}

