/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import org.alfresco.cmis.CMISAllowedActionEnum;
import org.alfresco.cmis.mapping.AbstractActionEvaluator;
import org.alfresco.cmis.mapping.PermissionActionEvaluator;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public class CanCheckInActionEvaluator
extends AbstractActionEvaluator<NodeRef> {
    private NodeService nodeService;
    private PermissionActionEvaluator permissionEvaluator;

    protected CanCheckInActionEvaluator(ServiceRegistry serviceRegistry) {
        super(serviceRegistry, CMISAllowedActionEnum.CAN_CHECKIN);
        this.permissionEvaluator = new PermissionActionEvaluator(serviceRegistry, CMISAllowedActionEnum.CAN_CHECKIN, false, "CheckIn");
        this.nodeService = serviceRegistry.getNodeService();
    }

    @Override
    public boolean isAllowed(NodeRef object) {
        if (null != object && this.nodeService.exists(object)) {
            return this.permissionEvaluator.isAllowed(object) && this.nodeService.hasAspect(object, ContentModel.ASPECT_WORKING_COPY);
        }
        return false;
    }
}

