/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.util.LinkedList;
import java.util.List;
import org.alfresco.cmis.CMISAllowedActionEnum;
import org.alfresco.cmis.mapping.AbstractActionEvaluator;
import org.alfresco.cmis.mapping.AspectActionEvaluator;
import org.alfresco.cmis.mapping.ObjectLockedActionEvaluator;
import org.alfresco.cmis.mapping.ParentTypeActionEvaluator;
import org.alfresco.cmis.mapping.PermissionActionEvaluator;
import org.alfresco.cmis.mapping.PropertyActionEvaluator;
import org.alfresco.cmis.mapping.TypeAttributeActionEvaluator;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class CompositeActionEvaluator<ObjectType>
extends AbstractActionEvaluator<ObjectType> {
    private List<AbstractActionEvaluator<ObjectType>> conditions = new LinkedList<AbstractActionEvaluator<ObjectType>>();
    private boolean defaultAllowing;
    private boolean requiresDisjunction;

    public CompositeActionEvaluator(boolean defaultAllowing, ServiceRegistry serviceRegistry, CMISAllowedActionEnum action) {
        super(serviceRegistry, action);
        this.defaultAllowing = defaultAllowing;
    }

    @Override
    public boolean isAllowed(ObjectType object) {
        boolean result = this.defaultAllowing;
        for (AbstractActionEvaluator<ObjectType> evaluator : this.conditions) {
            result = evaluator.isAllowed(object);
            if ((!this.requiresDisjunction || !result) && (this.requiresDisjunction || result)) continue;
            break;
        }
        return result;
    }

    public CompositeActionEvaluator<ObjectType> addPermissionCondition(String ... permissions) {
        if (null != permissions) {
            this.conditions.add(new PermissionActionEvaluator(this.getServiceRegistry(), this.getAction(), this.defaultAllowing, permissions));
        }
        return this;
    }

    public CompositeActionEvaluator<ObjectType> addPropertyCondition(PropertyActionEvaluator.PropertyDescriptor ... propertyIdsAndExpectedValues) {
        if (null != propertyIdsAndExpectedValues) {
            this.conditions.add(new PropertyActionEvaluator(this.getServiceRegistry(), this.getAction(), true, this.defaultAllowing, propertyIdsAndExpectedValues));
        }
        return this;
    }

    public CompositeActionEvaluator<ObjectType> addTypeAttributeCondition(TypeAttributeActionEvaluator.TypeDefinitionAttributeEnum attribute, Comparable<Object> comparator) {
        if (null != attribute && null != comparator) {
            this.conditions.add(new TypeAttributeActionEvaluator(attribute, (Pair<Object, Comparable<Object>>)new Pair(null, comparator), true, this.defaultAllowing, this.getServiceRegistry(), this.getAction()));
        }
        return this;
    }

    public CompositeActionEvaluator<ObjectType> addLockCondition(LockType lockType) {
        this.conditions.add(new ObjectLockedActionEvaluator(lockType, false, this.getServiceRegistry(), this.getAction()));
        return this;
    }

    public CompositeActionEvaluator<ObjectType> addPwcCondition(boolean pwcExpected) {
        this.conditions.add(new AspectActionEvaluator(this.getServiceRegistry(), this.getAction(), pwcExpected, true, this.defaultAllowing, ContentModel.ASPECT_WORKING_COPY));
        return this;
    }

    public CompositeActionEvaluator<ObjectType> addAspectCondition(boolean expected, QName ... aspects) {
        this.conditions.add(new AspectActionEvaluator(this.getServiceRegistry(), this.getAction(), expected, true, this.defaultAllowing, aspects));
        return this;
    }

    public CompositeActionEvaluator<ObjectType> addParentTypeCondition(ParentTypeActionEvaluator.ParentTypeEnum parentType) {
        this.conditions.add(new ParentTypeActionEvaluator(this.getServiceRegistry(), this.getAction(), parentType, true));
        return this;
    }

    public CompositeActionEvaluator<ObjectType> addCondition(AbstractActionEvaluator<ObjectType> condition) {
        if (null != condition) {
            this.conditions.add(condition);
        }
        return this;
    }
}

