/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.io.Serializable;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.cmis.mapping.AbstractProperty;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.SearchLanguageConversion;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class FixedValueProperty
extends AbstractProperty {
    private Serializable fixedValue;

    public FixedValueProperty(ServiceRegistry serviceRegistry, String propertyName, Serializable fixedValue) {
        super(serviceRegistry, propertyName);
        this.fixedValue = fixedValue;
    }

    @Override
    public Serializable getValue(NodeRef nodeRef) {
        return this.fixedValue;
    }

    @Override
    public Serializable getValue(AssociationRef assocRef) {
        return this.fixedValue;
    }

    @Override
    public Query buildLuceneEquality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        if (EqualsHelper.nullSafeEquals((Object)value, (Object)this.fixedValue)) {
            return new MatchAllDocsQuery();
        }
        return new TermQuery(new Term("NO_TOKENS", "__"));
    }

    @Override
    public Query buildLuceneExists(AbstractLuceneQueryParser lqp, Boolean not) throws ParseException {
        if (not.booleanValue()) {
            if (this.fixedValue == null) {
                return new MatchAllDocsQuery();
            }
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        if (this.fixedValue == null) {
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        return new MatchAllDocsQuery();
    }

    @Override
    public Query buildLuceneGreaterThan(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        if (value instanceof Comparable) {
            Comparable comparable = (Comparable)((Object)value);
            if (comparable.compareTo(this.fixedValue) > 0) {
                return new MatchAllDocsQuery();
            }
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        return new TermQuery(new Term("NO_TOKENS", "__"));
    }

    @Override
    public Query buildLuceneGreaterThanOrEquals(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        if (value instanceof Comparable) {
            Comparable comparable = (Comparable)((Object)value);
            if (comparable.compareTo(this.fixedValue) >= 0) {
                return new MatchAllDocsQuery();
            }
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        return new TermQuery(new Term("NO_TOKENS", "__"));
    }

    @Override
    public Query buildLuceneIn(AbstractLuceneQueryParser lqp, Collection<Serializable> values, Boolean not, PredicateMode mode) throws ParseException {
        boolean in = false;
        for (Serializable value : values) {
            if (!EqualsHelper.nullSafeEquals((Object)value, (Object)this.fixedValue)) continue;
            in = true;
            break;
        }
        if (in == (not == false)) {
            return new MatchAllDocsQuery();
        }
        return new TermQuery(new Term("NO_TOKENS", "__"));
    }

    @Override
    public Query buildLuceneInequality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        if (!EqualsHelper.nullSafeEquals((Object)value, (Object)this.fixedValue)) {
            return new MatchAllDocsQuery();
        }
        return new TermQuery(new Term("NO_TOKENS", "__"));
    }

    @Override
    public Query buildLuceneLessThan(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        if (value instanceof Comparable) {
            Comparable comparable = (Comparable)((Object)value);
            if (comparable.compareTo(this.fixedValue) < 0) {
                return new MatchAllDocsQuery();
            }
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        return new TermQuery(new Term("NO_TOKENS", "__"));
    }

    @Override
    public Query buildLuceneLessThanOrEquals(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        if (value instanceof Comparable) {
            Comparable comparable = (Comparable)((Object)value);
            if (comparable.compareTo(this.fixedValue) <= 0) {
                return new MatchAllDocsQuery();
            }
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        return new TermQuery(new Term("NO_TOKENS", "__"));
    }

    @Override
    public Query buildLuceneLike(AbstractLuceneQueryParser lqp, Serializable value, Boolean not) throws ParseException {
        if (value != null) {
            String target;
            boolean matches = false;
            Object converted = DefaultTypeConverter.INSTANCE.convert(value.getClass(), (Object)value);
            String asString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, converted);
            String regExpression = SearchLanguageConversion.convertSQLLikeToRegex((String)asString);
            Pattern pattern = Pattern.compile(regExpression);
            Matcher matcher = pattern.matcher(target = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.fixedValue));
            if (matcher.matches()) {
                matches = true;
            }
            if (matches == (not == false)) {
                return new MatchAllDocsQuery();
            }
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        return new TermQuery(new Term("NO_TOKENS", "__"));
    }

    @Override
    public String getLuceneSortField(AbstractLuceneQueryParser lqp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLuceneFieldName() {
        throw new UnsupportedOperationException();
    }
}

