/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import org.alfresco.cmis.mapping.AbstractActionEvaluator;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;

public class ParentActionEvaluator
extends AbstractActionEvaluator<NodeRef> {
    private AbstractActionEvaluator<NodeRef> evaluator;

    protected ParentActionEvaluator(AbstractActionEvaluator<NodeRef> evaluator) {
        super(evaluator.getServiceRegistry(), evaluator.getAction());
        this.evaluator = evaluator;
    }

    @Override
    public boolean isAllowed(NodeRef nodeRef) {
        if (nodeRef.equals((Object)this.getServiceRegistry().getCMISService().getDefaultRootNodeRef())) {
            return false;
        }
        ChildAssociationRef car = this.getServiceRegistry().getNodeService().getPrimaryParent(nodeRef);
        if (car != null && car.getParentRef() != null) {
            return this.evaluator.isAllowed(car.getParentRef());
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ParentActionEvaluator[evaluator=").append(this.evaluator).append("]");
        return builder.toString();
    }
}

