/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.io.Serializable;
import org.alfresco.cmis.CMISAllowedActionEnum;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.cmis.mapping.AbstractActionEvaluator;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;

public class PropertyActionEvaluator<ValidatingObjectType>
extends AbstractActionEvaluator<ValidatingObjectType> {
    private PropertyDescriptor[] propertyIdsAndExpectedValues;
    private boolean allPropertiesConcur;
    private boolean defaultAllowing;

    public PropertyActionEvaluator(ServiceRegistry serviceRegistry, CMISAllowedActionEnum action, boolean allPropertiesConcur, boolean defaultAllowing, PropertyDescriptor ... propertyIdsAndExpectedValues) {
        super(serviceRegistry, action);
        this.propertyIdsAndExpectedValues = propertyIdsAndExpectedValues;
        this.allPropertiesConcur = allPropertiesConcur;
    }

    @Override
    public boolean isAllowed(ValidatingObjectType object) {
        boolean result = this.defaultAllowing;
        if (null != this.propertyIdsAndExpectedValues) {
            for (PropertyDescriptor descriptor : this.propertyIdsAndExpectedValues) {
                Serializable left;
                block6: {
                    if (null == descriptor || null == descriptor.getPropertyId()) continue;
                    left = null;
                    try {
                        if (object instanceof NodeRef) {
                            left = this.getServiceRegistry().getCMISService().getProperty((NodeRef)object, descriptor.getPropertyId());
                            break block6;
                        }
                        if (object instanceof AssociationRef) {
                            left = this.getServiceRegistry().getCMISService().getProperty((AssociationRef)object, descriptor.getPropertyId());
                            break block6;
                        }
                        return false;
                    }
                    catch (CMISInvalidArgumentException e) {
                        throw new RuntimeException(e.toString(), e);
                    }
                }
                result = descriptor.satisfies(left);
                if (this.allPropertiesConcur && !result || !this.allPropertiesConcur && result) break;
            }
        }
        return result;
    }

    public static class PropertyDescriptor {
        private String propertyId;
        private Serializable propertyValue;
        private boolean nullExpected;

        public PropertyDescriptor(String propertyId, Serializable propertyValue, boolean nullExpected) {
            this.propertyId = propertyId;
            this.propertyValue = propertyValue;
            this.nullExpected = nullExpected;
        }

        public String getPropertyId() {
            return this.propertyId;
        }

        public Serializable getPropertyValue() {
            return this.propertyValue;
        }

        public boolean isNullExpected() {
            return this.nullExpected;
        }

        public boolean satisfies(Serializable value) {
            if (!this.nullExpected) {
                return null != value;
            }
            return null != value ? value.equals(this.propertyValue) : null == this.propertyValue;
        }
    }
}

