/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.util.Collection;
import java.util.Map;
import org.alfresco.cmis.CMISAllowedActionEnum;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.mapping.AbstractActionEvaluator;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.util.Pair;

public class TypeAttributeActionEvaluator<ObjectType>
extends AbstractActionEvaluator<ObjectType> {
    private TypeDefinitionAttributeEnum attribute;
    private Pair<Object, Comparable<Object>> comparator;
    private boolean nullExpected;
    private boolean defaultAllowing;

    public TypeAttributeActionEvaluator(TypeDefinitionAttributeEnum attribute, Pair<Object, Comparable<Object>> comparator, boolean nullExpected, boolean defaultAllowing, ServiceRegistry serviceRegistry, CMISAllowedActionEnum action) {
        super(serviceRegistry, action);
        this.attribute = attribute;
        this.comparator = comparator;
        this.nullExpected = nullExpected;
        this.defaultAllowing = defaultAllowing;
    }

    @Override
    public boolean isAllowed(ObjectType object) {
        boolean result = this.defaultAllowing;
        if (null != object && null != this.attribute && null != this.comparator && null != this.comparator.getSecond()) {
            CMISTypeDefinition typeDefinition = null;
            try {
                typeDefinition = this.getServiceRegistry().getCMISService().getTypeDefinition(object);
            }
            catch (CMISInvalidArgumentException e) {
                throw new RuntimeException(e.toString(), e);
            }
            result = this.attribute.satisfies(typeDefinition, this.comparator, this.nullExpected, this.defaultAllowing);
        }
        return result;
    }

    public static enum TypeDefinitionAttributeEnum {
        PUBLIC("isPublic", true),
        TYPE_ID("getTypeId", true),
        QUERY_NAME("getQueryName", true),
        DISPLAY_NAME("getDisplayName", true),
        PARENT_TYPE("getParentType", false),
        SUB_TYPES("getSubTypes", false),
        BASE_TYPE("getBaseType", false),
        DESCRIPTION("getDescription", true),
        CREATABLE("isCreatable", true),
        FILEABLE("isFileable", true),
        QUERYABLE("isQueryable", true),
        FULL_TEXT_INDEXED("isFullTextIndexed", true),
        CONTROLLABLE_POLICY("isControllablePolicy", true),
        CONTROLLABLE_ACL("isControllableACL", true),
        INCLUDED_IN_SUPER_TYPE_QUERY("isIncludedInSuperTypeQuery", true),
        VERSIONABLE("isVersionable", true),
        CONTENT_STREAM_ALLOWED("getContentStreamAllowed", true),
        ALLOWED_SOURCE_TYPES("getAllowedSourceTypes", false),
        ALLOWED_TARGET_TYPES("getAllowedTargetTypes", false),
        PROPERTY_DEFINITIONS("getPropertyDefinitions", false),
        OWNED_PROPERTY_DEFINITIONS("getOwnedPropertyDefinitions", false);

        private String methodName;
        private boolean primitiveType;

        private TypeDefinitionAttributeEnum(String methodName, boolean primitiveType) {
            this.methodName = methodName;
            this.primitiveType = primitiveType;
        }

        public boolean satisfies(CMISTypeDefinition typeDefinition, Pair<Object, Comparable<Object>> comparator, boolean nullExpected, boolean defaultAllowing) {
            if (null == typeDefinition) {
                return defaultAllowing;
            }
            Object actualValue = null;
            try {
                actualValue = typeDefinition.getClass().getMethod(this.methodName, new Class[0]).invoke((Object)typeDefinition, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Interface of '" + CMISTypeDefinition.class.getName() + "' has been modified!");
            }
            if (null == actualValue && !this.primitiveType) {
                return defaultAllowing;
            }
            if (actualValue instanceof Map) {
                actualValue = ((Map)actualValue).get(comparator.getFirst());
            } else if (actualValue instanceof Collection) {
                actualValue = ((Collection)actualValue).toArray()[(Integer)comparator.getFirst()];
            }
            if (!nullExpected) {
                return null != actualValue;
            }
            return 0 == ((Comparable)comparator.getSecond()).compareTo(actualValue);
        }
    }
}

