/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server.impl.subetha;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.alfresco.email.server.EmailServer;
import org.alfresco.email.server.impl.subetha.SubethaEmailMessage;
import org.alfresco.service.cmr.email.EmailDelivery;
import org.alfresco.service.cmr.email.EmailMessageException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.TooMuchDataException;
import org.subethamail.smtp.auth.EasyAuthenticationHandlerFactory;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.io.DeferredFileOutputStream;
import org.subethamail.smtp.server.SMTPServer;

public class SubethaEmailServer
extends EmailServer {
    private static final Log logger = LogFactory.getLog(SubethaEmailServer.class);
    private SMTPServer serverImpl;

    protected SubethaEmailServer() {
    }

    @Override
    public void startup() {
        this.serverImpl = new SMTPServer((MessageHandlerFactory)new HandlerFactory());
        this.serverImpl.setPort(this.getPort());
        this.serverImpl.setHostName(this.getDomain());
        this.serverImpl.setMaxConnections(this.getMaxConnections());
        this.serverImpl.setHideTLS(this.isHideTLS());
        this.serverImpl.setEnableTLS(this.isEnableTLS());
        this.serverImpl.setRequireTLS(this.isRequireTLS());
        if (this.isAuthenticate()) {
            EasyAuthenticationHandlerFactory authenticationHandler = new EasyAuthenticationHandlerFactory((UsernamePasswordValidator)new AlfrescoLoginUsernamePasswordValidator());
            this.serverImpl.setAuthenticationHandlerFactory((AuthenticationHandlerFactory)authenticationHandler);
        }
        this.serverImpl.start();
        log.info((Object)("Inbound SMTP Email Server has started successfully, on hostName:" + this.getDomain() + "port:" + this.getPort()));
    }

    @Override
    public void shutdown() {
        this.serverImpl.stop();
        log.info((Object)"Inbound SMTP Email Server has stopped successfully");
    }

    class Handler
    implements MessageHandler {
        private int DEFAULT_DATA_DEFERRED_SIZE = 0x700000;
        private List<String> EMPTY_LIST = new LinkedList<String>();
        private MessageContext messageContext;
        private String from;
        List<EmailDelivery> deliveries = new ArrayList<EmailDelivery>();

        public Handler(MessageContext messageContext) {
            this.messageContext = messageContext;
        }

        public MessageContext getMessageContext() {
            return this.messageContext;
        }

        public void from(String fromString) throws RejectException {
            try {
                InternetAddress a = new InternetAddress(fromString);
                this.from = a.getAddress();
            }
            catch (AddressException e) {
                // empty catch block
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("check whether user is allowed to send email from" + this.from));
                }
                SubethaEmailServer.this.filterSender(this.from);
            }
            catch (EmailMessageException e) {
                throw new RejectException(554, e.getMessage());
            }
        }

        public void recipient(String recipient) throws RejectException {
            AuthenticationHandler auth = this.messageContext.getAuthenticationHandler();
            this.deliveries.add(new EmailDelivery(recipient, this.from, auth != null ? (String)auth.getIdentity() : null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void data(InputStream data) throws TooMuchDataException, IOException, RejectException {
            if (this.deliveries.size() == 1) {
                EmailDelivery delivery = this.deliveries.get(0);
                this.processDelivery(delivery, data);
            } else if (this.deliveries.size() > 1) {
                DeferredFileOutputStream dfos = null;
                try {
                    int bytesRead;
                    dfos = new DeferredFileOutputStream(this.DEFAULT_DATA_DEFERRED_SIZE);
                    byte[] bytes = new byte[8192];
                    while ((bytesRead = data.read(bytes)) != -1) {
                        dfos.write(bytes, 0, bytesRead);
                    }
                    for (EmailDelivery delivery : this.deliveries) {
                        this.processDelivery(delivery, dfos.getInputStream());
                    }
                }
                finally {
                    try {
                        dfos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private void processDelivery(EmailDelivery delivery, InputStream data) throws RejectException {
            try {
                SubethaEmailMessage emailMessage = new SubethaEmailMessage(data);
                SubethaEmailServer.this.getEmailService().importMessage(delivery, emailMessage);
            }
            catch (EmailMessageException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"about to raise EmailMessageException", (Throwable)e);
                }
                throw new RejectException(554, e.getMessage());
            }
            catch (Throwable e) {
                log.error((Object)e.getMessage(), e);
                throw new RejectException(554, "An internal error prevented mail delivery.");
            }
        }

        public void done() {
            this.deliveries.clear();
        }
    }

    class HandlerFactory
    implements MessageHandlerFactory {
        HandlerFactory() {
        }

        public MessageHandler create(MessageContext messageContext) {
            return new Handler(messageContext);
        }
    }

    class AlfrescoLoginUsernamePasswordValidator
    implements UsernamePasswordValidator {
        AlfrescoLoginUsernamePasswordValidator() {
        }

        public void login(String username, String password) throws LoginFailedException {
            if (!SubethaEmailServer.this.authenticateUserNamePassword(username, password.toCharArray())) {
                throw new LoginFailedException("unable to log on");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("User authenticated successfully" + username));
            }
        }
    }
}

