/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.filesys.alfresco.AlfrescoClientInfo;
import org.alfresco.filesys.alfresco.DesktopTarget;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.service.cmr.repository.NodeRef;

public class DesktopParams {
    private SrvSession m_session;
    private NodeRef m_folderNode;
    private NetworkFile m_folderFile;
    private List<DesktopTarget> m_targets;

    public DesktopParams() {
    }

    public DesktopParams(SrvSession sess, NodeRef folderNode, NetworkFile folderFile) {
        this.m_session = sess;
        this.m_folderNode = folderNode;
        this.m_folderFile = folderFile;
    }

    public final int numberOfTargetNodes() {
        return this.m_targets != null ? this.m_targets.size() : 0;
    }

    public final SrvSession getSession() {
        return this.m_session;
    }

    public final String getTicket() {
        ClientInfo cInfo = this.m_session.getClientInformation();
        if (cInfo != null && cInfo instanceof AlfrescoClientInfo) {
            AlfrescoClientInfo alfInfo = (AlfrescoClientInfo)cInfo;
            return alfInfo.getAuthenticationTicket();
        }
        return null;
    }

    public final NodeRef getFolderNode() {
        return this.m_folderNode;
    }

    public final NetworkFile getFolder() {
        return this.m_folderFile;
    }

    public final void setFolder(NetworkFile netFile) {
        this.m_folderFile = netFile;
    }

    public final DesktopTarget getTarget(int idx) {
        DesktopTarget deskTarget = null;
        if (this.m_targets != null && idx >= 0 && idx < this.m_targets.size()) {
            deskTarget = this.m_targets.get(idx);
        }
        return deskTarget;
    }

    public final void addTarget(DesktopTarget target) {
        if (this.m_targets == null) {
            this.m_targets = new ArrayList<DesktopTarget>();
        }
        this.m_targets.add(target);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append("Targets=");
        str.append(this.numberOfTargetNodes());
        str.append("]");
        return str.toString();
    }
}

