/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import java.util.Enumeration;
import org.alfresco.filesys.alfresco.AlfrescoClientInfo;
import org.alfresco.filesys.config.ServerConfigurationBean;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.InvalidUserException;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.config.ServerConfigurationAccessor;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.ShareMapper;
import org.alfresco.jlan.server.core.ShareType;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.core.SharedDeviceList;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.alfresco.jlan.server.filesys.quota.QuotaManager;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

public class HomeShareMapper
implements ShareMapper {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.filesys.alfresco.HomeShareMapper");
    public static final String HOME_FOLDER_SHARE = "HOME";
    private ServerConfigurationAccessor m_config;
    private String homeShareName = "HOME";
    private PersonService personService;
    private NodeService nodeService;
    private DiskInterface repoDiskInterface;
    private QuotaManager quotaManager;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"ServerConfiguration", (Object)this.m_config);
        PropertyCheck.mandatory((Object)this, (String)"Home share name", (Object)this.homeShareName);
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.getPersonService());
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.getNodeService());
        PropertyCheck.mandatory((Object)this, (String)"repoDiskInterface", (Object)this.getRepoDiskInterface());
    }

    public void setServerConfiguration(ServerConfiguration config) {
        this.m_config = config;
    }

    public void setHomeShareName(String shareName) {
        this.homeShareName = shareName;
    }

    public void initializeMapper(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.setServerConfiguration(config);
    }

    public final String getHomeFolderName() {
        return this.homeShareName;
    }

    public SharedDeviceList getShareList(String host, SrvSession sess, boolean allShares) {
        if (sess != null && sess.hasClientInformation() && !sess.hasDynamicShares() && sess.getClientInformation() instanceof AlfrescoClientInfo) {
            NodeRef homeSpaceRef;
            AlfrescoClientInfo client = (AlfrescoClientInfo)sess.getClientInformation();
            NodeRef personNode = this.getPersonService().getPerson(client.getUserName());
            if (personNode != null && (homeSpaceRef = (NodeRef)this.getNodeService().getProperty(personNode, ContentModel.PROP_HOMEFOLDER)) != null) {
                DiskSharedDevice homeShare = this.createHomeDiskShare(homeSpaceRef, client.getUserName());
                sess.addDynamicShare((SharedDevice)homeShare);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Added " + this.getHomeFolderName() + " share to list of shares for " + client.getUserName()));
                }
            }
        }
        SharedDeviceList shrList = new SharedDeviceList(this.getFilesystemsConfigSection().getShares());
        if (sess != null && sess.hasDynamicShares()) {
            shrList.addShares(sess.getDynamicShareList());
        }
        if (!allShares) {
            shrList.removeUnavailableShares();
        }
        return shrList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SharedDevice findShare(String tohost, String name, int typ, SrvSession sess, boolean create) throws Exception {
        SharedDevice share = null;
        if ((typ == 0 || typ == -1) && name.equalsIgnoreCase(this.getHomeFolderName()) && sess.getClientInformation() != null && sess.getClientInformation() instanceof AlfrescoClientInfo) {
            NodeRef personNode;
            AlfrescoClientInfo client = (AlfrescoClientInfo)sess.getClientInformation();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Map share " + name + ", type=" + ShareType.TypeAsString((int)typ) + ", client=" + (Object)((Object)client)));
            }
            if (client == null) throw new InvalidUserException("No home directory");
            if (sess.hasDynamicShares()) {
                share = sess.getDynamicShareList().findShare(name, typ, false);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  Reusing existing dynamic share for " + name));
                }
            }
            if (share == null && create && (personNode = this.getPersonService().getPerson(client.getUserName())) != null) {
                NodeRef homeSpaceRef = (NodeRef)this.getNodeService().getProperty(personNode, ContentModel.PROP_HOMEFOLDER);
                DiskSharedDevice diskShare = this.createHomeDiskShare(client.getHomeFolder(), client.getUserName());
                sess.addDynamicShare((SharedDevice)diskShare);
                share = diskShare;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  Mapped share " + name + " to " + client.getHomeFolder()));
                }
            }
        } else {
            FilesystemsConfigSection filesystemsConfigSection = this.getFilesystemsConfigSection();
            share = filesystemsConfigSection.getShares().findShare(name, typ, false);
            if (share == null) {
                share = filesystemsConfigSection.getShares().findShare(name, typ, true);
            }
        }
        if (share == null) return share;
        if (share.getContext() == null) return share;
        if (share.getContext().isAvailable()) return share;
        return null;
    }

    public void deleteShares(SrvSession sess) {
        if (!sess.hasDynamicShares()) {
            return;
        }
        SharedDeviceList shares = sess.getDynamicShareList();
        Enumeration enm = shares.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice shr = (SharedDevice)enm.nextElement();
            shr.getContext().CloseContext();
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Deleted dynamic share " + shr));
        }
        shares.removeAllShares();
    }

    public void closeMapper() {
    }

    private final DiskSharedDevice createHomeDiskShare(NodeRef homeFolderRef, String userName) {
        logger.debug((Object)("create home share for user " + userName));
        DiskInterface diskDrv = this.getRepoDiskInterface();
        ContentContext diskCtx = new ContentContext(this.getHomeFolderName(), "", "", homeFolderRef);
        if (this.getQuotaManager() != null) {
            diskCtx.setQuotaManager(this.getQuotaManager());
        }
        ServerConfigurationBean config = (ServerConfigurationBean)this.m_config;
        config.initialiseRuntimeContext("cifs.home." + userName, diskCtx);
        return new DiskSharedDevice(this.getHomeFolderName(), (DeviceInterface)diskDrv, (DiskDeviceContext)diskCtx, 8);
    }

    protected FilesystemsConfigSection getFilesystemsConfigSection() {
        return (FilesystemsConfigSection)this.m_config.getConfigSection("Filesystems");
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setRepoDiskInterface(DiskInterface repoDiskInterface) {
        this.repoDiskInterface = repoDiskInterface;
    }

    public DiskInterface getRepoDiskInterface() {
        return this.repoDiskInterface;
    }

    public void setQuotaManager(QuotaManager quotaManager) {
        this.quotaManager = quotaManager;
    }

    public QuotaManager getQuotaManager() {
        return this.quotaManager;
    }
}

