/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.auth.ftp;

import java.net.InetAddress;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.ExtendedServerConfigurationAccessor;
import org.alfresco.filesys.alfresco.AlfrescoClientInfo;
import org.alfresco.filesys.auth.PassthruServerFactory;
import org.alfresco.filesys.auth.ftp.FTPAuthenticatorBase;
import org.alfresco.jlan.ftp.FTPSrvSession;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.auth.PasswordEncryptor;
import org.alfresco.jlan.server.auth.passthru.AuthenticateSession;
import org.alfresco.jlan.server.auth.passthru.DomainMapping;
import org.alfresco.jlan.server.auth.passthru.PassthruServers;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.SecurityConfigSection;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.util.IPAddress;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.repo.security.authentication.ntlm.NLTMAuthenticator;
import org.springframework.extensions.config.ConfigElement;

public class PassthruFtpAuthenticator
extends FTPAuthenticatorBase {
    public static final int DefaultSessionTmo = 5000;
    public static final int MinSessionTmo = 2000;
    public static final int MaxSessionTmo = 30000;
    public static final int MinCheckInterval = 10;
    public static final int MaxCheckInterval = 900;
    public static final long PassthruKeepAliveInterval = 60000L;
    private PassthruServers m_passthruServers;
    private boolean m_localPassThruServers;
    private PasswordEncryptor m_passwordEncryptor;

    protected SecurityConfigSection getSecurityConfig() {
        return (SecurityConfigSection)this.serverConfiguration.getConfigSection("Security");
    }

    public void setPassthruServers(PassthruServers passthruServers) {
        this.m_passthruServers = passthruServers;
    }

    @Override
    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        ConfigElement protoOrderElem;
        ConfigElement domNameElem;
        ConfigElement srvNamesElem;
        ConfigElement sessTmoElem;
        PassthruServerFactory factory = new PassthruServerFactory();
        ConfigElement checkInterval = params.getChild("offlineCheckInterval");
        if (checkInterval != null) {
            try {
                factory.setOfflineCheckInterval(Integer.parseInt(checkInterval.getValue()));
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid offline check interval specified");
            }
        }
        if ((sessTmoElem = params.getChild("Timeout")) != null) {
            try {
                factory.setTimeout(Integer.parseInt(sessTmoElem.getValue()));
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid timeout value specified");
            }
        }
        ExtendedServerConfigurationAccessor configExtended = null;
        if (config instanceof ExtendedServerConfigurationAccessor) {
            configExtended = (ExtendedServerConfigurationAccessor)config;
        }
        if (params.getChild("LocalServer") != null && configExtended != null) {
            String server = configExtended.getLocalServerName(true);
            if (server == null) {
                throw new AlfrescoRuntimeException("Passthru authenticator failed to get local server name");
            }
            factory.setServer(server);
        }
        if ((srvNamesElem = params.getChild("Server")) != null && srvNamesElem.getValue().length() > 0) {
            factory.setServer(srvNamesElem.getValue());
        }
        if (params.getChild("LocalDomain") != null && configExtended != null) {
            factory.setDomain(configExtended.getLocalDomainName());
        }
        if ((domNameElem = params.getChild("Domain")) != null && domNameElem.getValue().length() > 0) {
            factory.setDomain(domNameElem.getValue());
        }
        if ((protoOrderElem = params.getChild("ProtocolOrder")) != null && protoOrderElem.getValue().length() > 0) {
            factory.setProtocolOrder(protoOrderElem.getValue());
        }
        factory.afterPropertiesSet();
        this.setPassthruServers((PassthruServers)factory.getObject());
        this.m_localPassThruServers = true;
        super.initialize(config, params);
    }

    @Override
    public void initialize() throws InvalidConfigurationException {
        super.initialize();
        AuthenticationComponent authenticationComponent = this.getAuthenticationComponent();
        if (authenticationComponent instanceof NLTMAuthenticator && ((NLTMAuthenticator)authenticationComponent).getNTLMMode() == NTLMMode.MD4_PROVIDER) {
            throw new AlfrescoRuntimeException("Wrong authentication setup for passthru authenticator (cannot be used with Alfresco users)");
        }
        this.m_passwordEncryptor = new PasswordEncryptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticateUser(ClientInfo client, FTPSrvSession sess) {
        if (!(client instanceof AlfrescoClientInfo)) {
            return false;
        }
        boolean authSts = false;
        UserTransaction tx = null;
        try {
            if (client.isGuest()) {
                this.doGuestLogon((AlfrescoClientInfo)client, (SrvSession)sess);
                authSts = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authenticated guest user " + client.getUserName() + " sts=" + authSts));
                }
                boolean bl = authSts;
                return bl;
            }
            tx = this.getTransactionService().getUserTransaction(false);
            tx.begin();
            authSts = this.doPassthruUserAuthentication(client, (SrvSession)sess);
            if (authSts && client.getLogonType() == 0) {
                this.checkForAdminUserName(client);
            }
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)ex);
            }
        }
        finally {
            if (tx != null) {
                try {
                    if (tx.getStatus() == 1) {
                        tx.rollback();
                    } else {
                        tx.commit();
                    }
                }
                catch (Exception ex) {}
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authenticated user " + client.getUserName() + " sts=" + authSts + " via Passthru"));
        }
        return authSts;
    }

    protected void doGuestLogon(AlfrescoClientInfo client, SrvSession sess) {
        this.getAuthenticationService().authenticateAsGuest();
        String ticket = this.getAuthenticationService().getCurrentTicket();
        client.setAuthenticationTicket(ticket);
        client.setGuest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doPassthruUserAuthentication(ClientInfo client, SrvSession sess) {
        boolean authSts = false;
        AuthenticateSession authSess = null;
        try {
            String domain = this.mapClientAddressToDomain(sess.getRemoteAddress());
            authSess = this.m_passthruServers.openSession(false, domain);
            if (authSess != null) {
                byte[] challenge = authSess.getEncryptionKey();
                byte[] ntlmHash = this.m_passwordEncryptor.generateEncryptedPassword(client.getPasswordAsString(), challenge, 1, client.getUserName(), null);
                authSess.doSessionSetup(client.getDomain(), client.getUserName(), null, null, ntlmHash, 0);
                if (authSess.isGuest()) {
                    this.doGuestLogon((AlfrescoClientInfo)client, sess);
                    authSts = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Passthru authenticate user=" + client.getUserName() + ", GUEST"));
                    }
                } else {
                    AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
                    this.getAuthenticationComponent().setCurrentUser(client.getUserName());
                    alfClient.setAuthenticationTicket(this.getAuthenticationService().getCurrentTicket());
                    authSts = true;
                    client.setLogonType(0);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Logged on user " + client.getUserName() + " ( address " + sess.getRemoteAddress() + ")"));
                    }
                }
                authSess.CloseSession();
                authSess = null;
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"Passthru error", (Throwable)ex);
        }
        finally {
            if (authSess != null) {
                try {
                    authSess.CloseSession();
                }
                catch (Exception ex) {}
            }
        }
        return authSts;
    }

    protected final String mapClientAddressToDomain(InetAddress clientIP) {
        if (!this.getSecurityConfig().hasDomainMappings()) {
            return null;
        }
        int clientAddr = IPAddress.asInteger((InetAddress)clientIP);
        for (DomainMapping domainMap : this.getSecurityConfig().getDomainMappings()) {
            if (!domainMap.isMemberOfDomain(clientAddr)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Mapped client IP " + clientIP + " to domain " + domainMap.getDomain()));
            }
            return domainMap.getDomain();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Failed to map client IP " + clientIP + " to a domain"));
        }
        return null;
    }

    @Override
    public void closeAuthenticator() {
        super.closeAuthenticator();
        if (this.m_localPassThruServers && this.m_passthruServers != null) {
            this.m_passthruServers.shutdown();
        }
    }
}

