/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.config.acl;

import java.util.Collections;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.config.acl.AccessControlBean;
import org.alfresco.filesys.config.acl.DomainAccessControlBean;
import org.alfresco.filesys.config.acl.GidAccessControlBean;
import org.alfresco.filesys.config.acl.IpAddressAccessControlBean;
import org.alfresco.filesys.config.acl.ProtocolAccessControlBean;
import org.alfresco.filesys.config.acl.UidAccessControlBean;
import org.alfresco.filesys.config.acl.UserAccessControlBean;
import org.alfresco.jlan.server.auth.acl.ACLParseException;
import org.alfresco.jlan.server.auth.acl.AccessControl;
import org.alfresco.jlan.server.auth.acl.AccessControlList;
import org.alfresco.jlan.server.auth.acl.AccessControlManager;
import org.alfresco.jlan.server.auth.acl.AccessControlParser;
import org.alfresco.jlan.server.auth.acl.DefaultAccessControlManager;
import org.alfresco.jlan.server.auth.acl.InvalidACLTypeException;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.SecurityConfigSection;

public class AccessControlListBean {
    private int defaultAccessLevel = -1;
    private List<DomainAccessControlBean> domainAccessControls = Collections.emptyList();
    private List<GidAccessControlBean> gidAccessControls = Collections.emptyList();
    private List<IpAddressAccessControlBean> ipAddressAccessControls = Collections.emptyList();
    private List<ProtocolAccessControlBean> protocolAccessControls = Collections.emptyList();
    private List<UidAccessControlBean> uidAccessControls = Collections.emptyList();
    private List<UserAccessControlBean> userAccessControls = Collections.emptyList();

    public String getDefaultAccessLevel() {
        return AccessControl.asAccessString((int)this.defaultAccessLevel);
    }

    public void setDefaultAccessLevel(String defaultAccessLevel) throws ACLParseException {
        if (defaultAccessLevel != null && defaultAccessLevel.length() > 0) {
            this.defaultAccessLevel = AccessControlParser.parseAccessTypeString((String)defaultAccessLevel);
        }
    }

    public List<DomainAccessControlBean> getDomainAccessControls() {
        return this.domainAccessControls;
    }

    public void setDomainAccessControls(List<DomainAccessControlBean> domainAccessControls) {
        this.domainAccessControls = domainAccessControls;
    }

    public List<GidAccessControlBean> getGidAccessControls() {
        return this.gidAccessControls;
    }

    public void setGidAccessControls(List<GidAccessControlBean> gidAccessControls) {
        this.gidAccessControls = gidAccessControls;
    }

    public List<IpAddressAccessControlBean> getIpAddressAccessControls() {
        return this.ipAddressAccessControls;
    }

    public void setIpAddressAccessControls(List<IpAddressAccessControlBean> ipAddressAccessControls) {
        this.ipAddressAccessControls = ipAddressAccessControls;
    }

    public List<ProtocolAccessControlBean> getProtocolAccessControls() {
        return this.protocolAccessControls;
    }

    public void setProtocolAccessControls(List<ProtocolAccessControlBean> protocolAccessControls) {
        this.protocolAccessControls = protocolAccessControls;
    }

    public List<UidAccessControlBean> getUidAccessControls() {
        return this.uidAccessControls;
    }

    public void setUidAccessControls(List<UidAccessControlBean> uidAccessControls) {
        this.uidAccessControls = uidAccessControls;
    }

    public List<UserAccessControlBean> getUserAccessControls() {
        return this.userAccessControls;
    }

    public void setUserAccessControls(List<UserAccessControlBean> userAccessControls) {
        this.userAccessControls = userAccessControls;
    }

    public AccessControlList toAccessControlList(SecurityConfigSection secConfig) throws InvalidConfigurationException {
        AccessControlList acls = new AccessControlList();
        if (this.defaultAccessLevel != -1) {
            try {
                acls.setDefaultAccessLevel(this.defaultAccessLevel);
            }
            catch (InvalidACLTypeException ex) {
                throw new AlfrescoRuntimeException("Default access level error", (Throwable)ex);
            }
        }
        for (AccessControlBean accessControlBean : this.getDomainAccessControls()) {
            acls.addControl(accessControlBean.toAccessControl());
        }
        for (AccessControlBean accessControlBean : this.getGidAccessControls()) {
            acls.addControl(accessControlBean.toAccessControl());
        }
        for (AccessControlBean accessControlBean : this.getIpAddressAccessControls()) {
            acls.addControl(accessControlBean.toAccessControl());
        }
        for (AccessControlBean accessControlBean : this.getProtocolAccessControls()) {
            acls.addControl(accessControlBean.toAccessControl());
        }
        for (AccessControlBean accessControlBean : this.getUidAccessControls()) {
            acls.addControl(accessControlBean.toAccessControl());
        }
        for (AccessControlBean accessControlBean : this.getUserAccessControls()) {
            acls.addControl(accessControlBean.toAccessControl());
        }
        if (acls.numberOfControls() == 0) {
            if (this.defaultAccessLevel == -1) {
                return null;
            }
            if (acls.getDefaultAccessLevel() == 0) {
                throw new AlfrescoRuntimeException("Empty access control list and default access 'None' not allowed");
            }
        }
        if (secConfig.getAccessControlManager() == null) {
            secConfig.setAccessControlManager((AccessControlManager)new DefaultAccessControlManager());
        }
        return acls;
    }
}

