/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.alfresco.filesys.repo.LockKeeper;
import org.alfresco.repo.cache.TransactionalCache;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LockKeeperImpl
implements LockKeeper {
    private String LOCK_KEEPER_KEY = "AlfrescoLockKeeperImpl";
    private LockService lockService;
    private TransactionService transactionService;
    private TransactionalCache<NodeRef, KeeperInfo> lockKeeperTransactionalCache;
    private int timeToExpire = 7200;
    private boolean lockEnabled = true;
    private static final Log logger = LogFactory.getLog(LockKeeperImpl.class);

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"lockService", (Object)this.getLockService());
        PropertyCheck.mandatory((Object)this, (String)"lockKeeperTransactionalCache", this.getLockKeeperTransactionalCache());
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.getTransactionService());
    }

    @Override
    public void addLock(NodeRef nodeRef) {
        if (this.lockEnabled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("lock nodeRef:" + nodeRef));
            }
            this.getLockService().lock(nodeRef, LockType.WRITE_LOCK, this.getTimeToExpire(), Lifetime.EPHEMERAL, this.LOCK_KEEPER_KEY);
            this.lockKeeperTransactionalCache.put(nodeRef, new KeeperInfo(AuthenticationUtil.getFullyAuthenticatedUser()));
        }
    }

    @Override
    public void removeLock(NodeRef nodeRef) {
        if (this.lockEnabled) {
            logger.trace((Object)("removeLock nodeRef:" + nodeRef));
            this.getLockService().unlock(nodeRef);
            this.lockKeeperTransactionalCache.remove(nodeRef);
        }
    }

    @Override
    public void refreshAllLocks() {
        Collection<NodeRef> nodes = this.lockKeeperTransactionalCache.getKeys();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("RefreshAllLocks called for #locks, " + nodes.size()));
        }
        if (!this.transactionService.getAllowWrite() && logger.isTraceEnabled()) {
            logger.trace((Object)"Repo is read only - do nothing");
            return;
        }
        Iterator<NodeRef> i$ = nodes.iterator();
        while (i$.hasNext()) {
            NodeRef nodeRef;
            final NodeRef nodeRefToRefresh = nodeRef = i$.next();
            final KeeperInfo keeperInfo = this.lockKeeperTransactionalCache.get(nodeRefToRefresh);
            final String additionalInfo = this.lockService.getAdditionalInfo(nodeRefToRefresh);
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    if (LockKeeperImpl.this.LOCK_KEEPER_KEY.equalsIgnoreCase(additionalInfo)) {
                        AuthenticationUtil.setFullyAuthenticatedUser((String)keeperInfo.getOwner());
                        switch (LockKeeperImpl.this.lockService.getLockStatus(nodeRefToRefresh)) {
                            case LOCK_OWNER: {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("refresh ephemeral lock nodeRef: " + nodeRefToRefresh));
                                }
                                LockKeeperImpl.this.getLockService().lock(nodeRefToRefresh, LockType.WRITE_LOCK, LockKeeperImpl.this.getTimeToExpire(), Lifetime.EPHEMERAL, LockKeeperImpl.this.LOCK_KEEPER_KEY);
                                break;
                            }
                            default: {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("remove lock from lock keeper cache, nodeRef: " + nodeRefToRefresh));
                                }
                                LockKeeperImpl.this.lockKeeperTransactionalCache.remove(nodeRefToRefresh);
                                break;
                            }
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("not a lock keeper lock, remove lock from lock keeper cache, nodeRef: " + nodeRefToRefresh));
                        }
                        LockKeeperImpl.this.lockKeeperTransactionalCache.remove(nodeRefToRefresh);
                    }
                    return null;
                }
            }, false, true);
        }
    }

    public void setLockEnabled(boolean lockEnabled) {
        this.lockEnabled = lockEnabled;
    }

    public boolean isLockEnabled() {
        return this.lockEnabled;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public LockService getLockService() {
        return this.lockService;
    }

    public void setLockKeeperTransactionalCache(TransactionalCache<NodeRef, KeeperInfo> lockKeeperTransactionalCache) {
        this.lockKeeperTransactionalCache = lockKeeperTransactionalCache;
    }

    public TransactionalCache<NodeRef, KeeperInfo> getLockKeeperTransactionalCache() {
        return this.lockKeeperTransactionalCache;
    }

    public void setTransactionService(TransactionService transactionHelper) {
        this.transactionService = transactionHelper;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setTimeToExpire(int timeToExpire) {
        this.timeToExpire = timeToExpire;
    }

    public int getTimeToExpire() {
        return this.timeToExpire;
    }

    private class KeeperInfo
    implements Serializable {
        private static final long serialVersionUID = -4200553975218699638L;
        private String owner;
        Date lockTime;

        KeeperInfo(String owner) {
            this.setOwner(owner);
            this.lockTime = new Date();
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public String getOwner() {
            return this.owner;
        }
    }
}

