/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.DependentInstance;
import org.alfresco.filesys.repo.rules.EvaluatorContext;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.RuleEvaluator;
import org.alfresco.filesys.repo.rules.Scenario;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.ScenarioInstanceRenameAware;
import org.alfresco.filesys.repo.rules.ScenarioResult;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuleEvaluatorImpl
implements RuleEvaluator {
    private static Log logger = LogFactory.getLog(RuleEvaluatorImpl.class);
    private List<Scenario> scenarios;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"scenarios", this.scenarios);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Command evaluate(EvaluatorContext context, Operation operation) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("evaluate:" + operation));
        }
        ArrayList<ScenarioResult> results = new ArrayList<ScenarioResult>(5);
        List<ScenarioInstance> list = context.getScenarioInstances();
        synchronized (list) {
            for (Scenario scenario : this.scenarios) {
                ScenarioInstance instance = scenario.createInstance(context, operation);
                if (instance == null) continue;
                context.getScenarioInstances().add(instance);
            }
            Iterator<ScenarioInstance> i = context.getScenarioInstances().iterator();
            while (i.hasNext()) {
                Command executor;
                ScenarioInstance scenarioInstance = i.next();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("evaluating:" + scenarioInstance + " operation: " + operation));
                }
                if ((executor = scenarioInstance.evaluate(operation)) != null) {
                    results.add(new ScenarioResult(scenarioInstance, executor));
                }
                if (!scenarioInstance.isComplete()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Scenario is complete:" + scenarioInstance));
                }
                i.remove();
            }
        }
        HashMap<ScenarioInstance.Ranking, ScenarioResult> executors = new HashMap<ScenarioInstance.Ranking, ScenarioResult>();
        for (ScenarioResult scenarioResult : results) {
            executors.put(scenarioResult.scenario.getRanking(), scenarioResult);
        }
        ScenarioResult ex = (ScenarioResult)executors.get((Object)ScenarioInstance.Ranking.HIGH);
        if (ex != null) {
            if (ex.scenario instanceof DependentInstance) {
                DependentInstance dependentInstance = (DependentInstance)((Object)ex.scenario);
                for (ScenarioResult looser : results) {
                    if (ex == looser) continue;
                    Command c = dependentInstance.win(results, ex.command);
                    logger.debug((Object)"returning merged high priority executor");
                    return c;
                }
            }
            logger.debug((Object)"returning high priority executor");
            return ex.command;
        }
        ex = (ScenarioResult)executors.get((Object)ScenarioInstance.Ranking.MEDIUM);
        if (ex != null) {
            logger.debug((Object)"returning medium priority executor");
            return ex.command;
        }
        ex = (ScenarioResult)executors.get((Object)ScenarioInstance.Ranking.LOW);
        if (ex != null) {
            logger.debug((Object)"returning low priority executor");
            return ex.command;
        }
        return null;
    }

    public void setScenarios(List<Scenario> scenarios) {
        this.scenarios = scenarios;
    }

    public List<Scenario> getScenarios() {
        return this.scenarios;
    }

    @Override
    public EvaluatorContext createContext(Map<String, Object> sessionState) {
        EvaluatorContextImpl impl = new EvaluatorContextImpl(sessionState);
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRename(EvaluatorContext context, Operation operation, Command command) {
        List<ScenarioInstance> list = context.getScenarioInstances();
        synchronized (list) {
            for (ScenarioInstance scenario : context.getScenarioInstances()) {
                if (!(scenario instanceof ScenarioInstanceRenameAware)) continue;
                ScenarioInstanceRenameAware awareScenario = (ScenarioInstanceRenameAware)((Object)scenario);
                awareScenario.notifyRename(operation, command);
            }
        }
    }

    private class EvaluatorContextImpl
    implements EvaluatorContext {
        Map<String, Object> sessionState;
        private List<ScenarioInstance> currentScenarioInstances = new ArrayList<ScenarioInstance>();

        EvaluatorContextImpl(Map<String, Object> sessionState) {
            this.sessionState = sessionState;
        }

        @Override
        public List<ScenarioInstance> getScenarioInstances() {
            return this.currentScenarioInstances;
        }

        @Override
        public Map<String, Object> getSessionState() {
            return this.sessionState;
        }
    }
}

