/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.filesys.repo.rules.EvaluatorContext;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.Scenario;
import org.alfresco.filesys.repo.rules.ScenarioDoubleRenameShuffleInstance;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.operations.RenameFileOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScenarioDoubleRenameShuffle
implements Scenario {
    private static Log logger = LogFactory.getLog(ScenarioDoubleRenameShuffle.class);
    private Pattern pattern;
    private String strPattern;
    private Pattern interimPattern;
    private String strInterimPattern;
    private boolean deleteBackup;
    private boolean moveAsSystem;
    private long timeout = 30000L;
    private ScenarioInstance.Ranking ranking = ScenarioInstance.Ranking.HIGH;

    @Override
    public ScenarioInstance createInstance(EvaluatorContext ctx, Operation operation) {
        RenameFileOperation r;
        Matcher m;
        if (operation instanceof RenameFileOperation && (m = this.pattern.matcher((r = (RenameFileOperation)operation).getTo())).matches()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("New Scenario Double Rename Shuffle Instance strPattern:" + this.pattern + " matches" + r.getTo()));
            }
            ScenarioDoubleRenameShuffleInstance instance = new ScenarioDoubleRenameShuffleInstance();
            instance.setTimeout(this.timeout);
            instance.setRanking(this.ranking);
            instance.setDeleteBackup(this.deleteBackup);
            instance.setMoveAsSystem(this.moveAsSystem);
            if (this.interimPattern != null) {
                instance.setInterimPattern(this.interimPattern);
            }
            return instance;
        }
        return null;
    }

    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern, 2);
        this.strPattern = pattern;
    }

    public String getPattern() {
        return this.strPattern;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    public void setDeleteBackup(boolean deleteBackup) {
        this.deleteBackup = deleteBackup;
    }

    public boolean isDeleteBackup() {
        return this.deleteBackup;
    }

    public boolean isMoveAsSystem() {
        return this.moveAsSystem;
    }

    public void setMoveAsSystem(boolean retryAsSystem) {
        this.moveAsSystem = retryAsSystem;
    }

    public void setInterimPattern(String intermediateMovePattern) {
        if (null != intermediateMovePattern) {
            this.interimPattern = Pattern.compile(intermediateMovePattern, 2);
            this.strInterimPattern = intermediateMovePattern;
        }
    }

    public String getInterimPattern() {
        return this.strInterimPattern;
    }
}

