/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.filesys.repo.rules.EvaluatorContext;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.Scenario;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.ScenarioTempDeleteShuffleInstance;
import org.alfresco.filesys.repo.rules.operations.CreateFileOperation;
import org.alfresco.filesys.repo.rules.operations.DeleteFileOperation;
import org.alfresco.util.MaxSizeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScenarioTempDeleteShuffle
implements Scenario {
    private static Log logger = LogFactory.getLog(ScenarioTempDeleteShuffle.class);
    protected static final String SCENARIO_KEY = "org.alfresco.filesys.repo.rules.ScenarioTempDeleteShuffle";
    private Pattern tempDirPattern;
    private String strTempDirPattern;
    private Pattern pattern;
    private String strPattern;
    private long timeout = 30000L;
    private ScenarioInstance.Ranking ranking = ScenarioInstance.Ranking.HIGH;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScenarioInstance createInstance(EvaluatorContext ctx, Operation operation) {
        Map createdTempFiles;
        Matcher m;
        Operation c;
        String path;
        Matcher d;
        if (operation instanceof CreateFileOperation && (d = this.tempDirPattern.matcher(path = ((CreateFileOperation)(c = (CreateFileOperation)operation)).getPath())).matches()) {
            logger.debug((Object)"pattern matches temp dir folder so this is a new create in a temp dir");
            Matcher m2 = this.pattern.matcher(((CreateFileOperation)c).getName());
            if (m2.matches()) {
                Map<String, String> createdTempFiles2 = (Map<String, String>)ctx.getSessionState().get(SCENARIO_KEY);
                if (createdTempFiles2 == null) {
                    Map<String, Object> map = ctx.getSessionState();
                    synchronized (map) {
                        logger.debug((Object)"created new temp file map and added it to the session state");
                        createdTempFiles2 = (Map)ctx.getSessionState().get(SCENARIO_KEY);
                        if (createdTempFiles2 == null) {
                            createdTempFiles2 = Collections.synchronizedMap(new MaxSizeMap(5, false));
                            ctx.getSessionState().put(SCENARIO_KEY, createdTempFiles2);
                        }
                    }
                }
                createdTempFiles2.put(((CreateFileOperation)c).getName(), ((CreateFileOperation)c).getName());
            }
        }
        if (operation instanceof DeleteFileOperation && (m = this.pattern.matcher(((DeleteFileOperation)(c = (DeleteFileOperation)operation)).getName())).matches() && (createdTempFiles = (Map)ctx.getSessionState().get(SCENARIO_KEY)) != null && createdTempFiles.containsKey(((DeleteFileOperation)c).getName())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("New Scenario Temp Delete Shuffle Instance:" + ((DeleteFileOperation)c).getName()));
            }
            ScenarioTempDeleteShuffleInstance instance = new ScenarioTempDeleteShuffleInstance();
            instance.setTimeout(this.timeout);
            instance.setRanking(this.ranking);
            return instance;
        }
        return null;
    }

    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern, 2);
        this.strPattern = pattern;
    }

    public String getPattern() {
        return this.strPattern;
    }

    public void setTempDirPattern(String tempDirPattern) {
        this.tempDirPattern = Pattern.compile(tempDirPattern, 2);
        this.strTempDirPattern = tempDirPattern;
    }

    public String getTempDirPattern() {
        return this.strTempDirPattern;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }
}

