/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.importer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.importer.view.ElementContext;
import org.alfresco.repo.importer.view.NodeContext;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.alfresco.util.TempFileProvider;

public class PropertyContext
extends ElementContext {
    private NodeContext parentContext;
    private QName propertyName;
    private QName propertyType;
    private List<StringBuffer> values = new ArrayList<StringBuffer>();
    private Map<QName, FileWriter> contentWriters = new HashMap<QName, FileWriter>();

    public PropertyContext(QName elementName, NodeContext parentContext, QName propertyName, QName propertyType) {
        super(elementName, parentContext.getDictionaryService(), parentContext.getImporter());
        this.parentContext = parentContext;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    public NodeContext getNode() {
        return this.parentContext;
    }

    public QName getName() {
        return this.propertyName;
    }

    public QName getType() {
        return this.propertyType;
    }

    public boolean isMultiValue() {
        return this.values.size() > 1;
    }

    public boolean isNull() {
        return this.values.size() == 0;
    }

    public List<StringBuffer> getValues() {
        return this.values;
    }

    public void startValue() {
        StringBuffer buffer = new StringBuffer(128);
        if (this.propertyType.equals((Object)DataTypeDefinition.CONTENT)) {
            File tempFile = TempFileProvider.createTempFile((String)"import", (String)".tmp");
            try {
                FileWriter tempWriter = new FileWriter(tempFile);
                this.contentWriters.put(this.propertyName, tempWriter);
                ContentData contentData = new ContentData(tempFile.getAbsolutePath(), "application/octet-stream", 0L, tempWriter.getEncoding());
                buffer.append(contentData.toString());
            }
            catch (IOException e) {
                throw new ImporterException("Failed to create temporary content holder for property " + this.propertyName, e);
            }
        }
        this.values.add(buffer);
    }

    public void endValue() {
        if (this.propertyType.equals((Object)DataTypeDefinition.CONTENT)) {
            FileWriter tempWriter = this.contentWriters.get(this.propertyName);
            try {
                tempWriter.close();
                this.contentWriters.remove(this.propertyName);
            }
            catch (IOException e) {
                throw new ImporterException("Failed to create temporary content holder for property " + this.propertyName, e);
            }
        } else {
            StringBuffer buffer = this.values.get(this.values.size() - 1);
            this.values.set(this.values.size() - 1, new StringBuffer(ISO9075.decode((String)buffer.toString())));
        }
    }

    public void appendCharacters(char[] ch, int start, int length) {
        if (this.propertyType.equals((Object)DataTypeDefinition.CONTENT)) {
            FileWriter tempWriter = this.contentWriters.get(this.propertyName);
            try {
                tempWriter.write(ch, start, length);
            }
            catch (IOException e) {
                throw new ImporterException("Failed to write temporary content for property " + this.propertyName, e);
            }
        } else {
            StringBuffer buffer = this.values.get(this.values.size() - 1);
            buffer.append(ch, start, length);
        }
    }
}

