/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.security.AuthenticationService;

public class JCRProxyFactory {
    public static Object create(Object target, Class proxyInterface, SessionImpl context) {
        SessionContextInvocationHandler handler = new SessionContextInvocationHandler(target, context);
        return Proxy.newProxyInstance(proxyInterface.getClassLoader(), new Class[]{proxyInterface}, (InvocationHandler)handler);
    }

    private static class SessionContextInvocationHandler
    implements InvocationHandler {
        private Object target;
        private SessionImpl session;
        private AuthenticationService authenticationService;

        private SessionContextInvocationHandler(Object target, SessionImpl context) {
            this.target = target;
            this.session = context;
            this.authenticationService = this.session.getRepositoryImpl().getServiceRegistry().getAuthenticationService();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("equals")) {
                if (!Proxy.isProxyClass(args[0].getClass())) return false;
                return this.equals(Proxy.getInvocationHandler(args[0]));
            }
            try {
                String username = this.authenticationService.getCurrentUserName();
                try {
                    if (!method.getName().equals("logout") && username == null) {
                        this.authenticationService.validate(this.session.getTicket());
                    }
                    Object object = method.invoke(this.target, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    throw cause;
                }
                finally {
                    if (username == null) {
                        this.authenticationService.clearCurrentSecurityContext();
                    }
                }
            }
            catch (Throwable cause) {
                if (cause instanceof IntegrityException) {
                    throw new ConstraintViolationException(cause);
                }
                if (cause instanceof NodeLockedException) {
                    throw new LockException(cause);
                }
                if (cause instanceof InvalidTypeException) {
                    throw new NoSuchNodeTypeException(cause);
                }
                if (cause instanceof org.alfresco.repo.security.permissions.AccessDeniedException) {
                    throw new AccessDeniedException(cause);
                }
                if (!(cause instanceof AlfrescoRuntimeException)) throw cause;
                throw new RepositoryException(cause);
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof SessionContextInvocationHandler)) {
                return false;
            }
            SessionContextInvocationHandler other = (SessionContextInvocationHandler)obj;
            return this.target.equals(other.target);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            return this.target.toString();
        }
    }
}

