/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.ActivityPoster;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.InitializingBean;

public class ActivityPosterImpl
implements ActivityPoster,
InitializingBean {
    private static final String APP_TOOL = "CMIS";
    public static final char PathSeperatorChar = '/';
    private static Log logger = LogFactory.getLog(ActivityPoster.class);
    private ActivityService activityService;
    private SiteService siteService;
    private TenantService tenantService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private HiddenAspect hiddenAspect;
    private boolean activitiesEnabled = true;

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setActivitiesEnabled(boolean activitiesEnabled) {
        this.activitiesEnabled = activitiesEnabled;
    }

    private final String getPathFromNode(NodeRef rootNodeRef, NodeRef nodeRef) throws FileNotFoundException {
        if (rootNodeRef == null || nodeRef == null) {
            throw new IllegalArgumentException("Invalid node(s) in getPathFromNode call");
        }
        if (rootNodeRef.equals((Object)nodeRef)) {
            return "";
        }
        List<FileInfo> pathInfos = this.fileFolderService.getNamePath(rootNodeRef, nodeRef);
        StringBuilder sb = new StringBuilder(pathInfos.size() * 20);
        for (FileInfo fileInfo : pathInfos) {
            sb.append('/');
            sb.append(fileInfo.getName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Build name path for node: \n   root: " + rootNodeRef + "\n" + "   target: " + nodeRef + "\n" + "   path: " + sb));
        }
        return sb.toString();
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"activityService", (Object)this.activityService);
        PropertyCheck.mandatory((Object)this, (String)"siteService", (Object)this.siteService);
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.fileFolderService);
    }

    private String getCurrentTenantDomain() {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        if (tenantDomain == null) {
            return "";
        }
        return tenantDomain;
    }

    private boolean isFolder(NodeRef nodeRef) {
        QName typeQName = this.nodeService.getType(nodeRef);
        FileFolderServiceType type = this.fileFolderService.getType(typeQName);
        boolean isFolder = type.equals((Object)FileFolderServiceType.FOLDER);
        return isFolder;
    }

    @Override
    public void postFileFolderAdded(NodeRef nodeRef) {
        if (this.activitiesEnabled && !this.hiddenAspect.hasHiddenAspect(nodeRef)) {
            String siteId;
            SiteInfo siteInfo = this.siteService.getSite(nodeRef);
            String string = siteId = siteInfo != null ? siteInfo.getShortName() : null;
            if (siteId != null && !siteId.equals("")) {
                String name;
                boolean isFolder;
                String path;
                NodeRef parentNodeRef;
                block5: {
                    parentNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
                    path = null;
                    isFolder = this.isFolder(nodeRef);
                    name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                    if (isFolder) {
                        NodeRef documentLibrary = this.siteService.getContainer(siteId, "documentLibrary");
                        path = "/";
                        try {
                            path = this.getPathFromNode(documentLibrary, nodeRef);
                        }
                        catch (FileNotFoundException error) {
                            if (!logger.isDebugEnabled()) break block5;
                            logger.debug((Object)"No documentLibrary container found.");
                        }
                    }
                }
                this.postFileFolderActivity(isFolder ? "org.alfresco.documentlibrary.folder-added" : "org.alfresco.documentlibrary.file-added", path, parentNodeRef, nodeRef, siteId, name);
            }
        }
    }

    @Override
    public void postFileFolderUpdated(boolean isFolder, NodeRef nodeRef) {
        if (this.activitiesEnabled && !this.hiddenAspect.hasHiddenAspect(nodeRef)) {
            String siteId;
            SiteInfo siteInfo = this.siteService.getSite(nodeRef);
            String string = siteId = siteInfo != null ? siteInfo.getShortName() : null;
            if (siteId != null && !siteId.equals("")) {
                String fileName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                if (!isFolder) {
                    this.postFileFolderActivity("org.alfresco.documentlibrary.file-updated", null, null, nodeRef, siteId, fileName);
                }
            }
        }
    }

    @Override
    public void postFileFolderDeleted(ActivityInfo activityInfo) {
        if (this.activitiesEnabled && activityInfo.getSiteId() != null) {
            this.postFileFolderActivity(activityInfo.isFolder() ? "org.alfresco.documentlibrary.folder-deleted" : "org.alfresco.documentlibrary.file-deleted", activityInfo.getParentPath(), activityInfo.getParentNodeRef(), activityInfo.getNodeRef(), activityInfo.getSiteId(), activityInfo.getFileName());
        }
    }

    @Override
    public ActivityInfo getActivityInfo(NodeRef nodeRef) {
        String siteId;
        SiteInfo siteInfo = this.siteService.getSite(nodeRef);
        String string = siteId = siteInfo != null ? siteInfo.getShortName() : null;
        if (siteId != null && !siteId.equals("")) {
            String parentPath;
            boolean isFolder;
            String name;
            NodeRef parentNodeRef;
            block3: {
                parentNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
                FileInfo fileInfo = this.fileFolderService.getFileInfo(nodeRef);
                name = fileInfo.getName();
                isFolder = fileInfo.isFolder();
                NodeRef documentLibrary = this.siteService.getContainer(siteId, "documentLibrary");
                parentPath = "/";
                try {
                    parentPath = this.getPathFromNode(documentLibrary, parentNodeRef);
                }
                catch (FileNotFoundException error) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)"No documentLibrary container found.");
                }
            }
            return new ActivityInfo(nodeRef, parentPath, parentNodeRef, siteId, name, isFolder);
        }
        return null;
    }

    private void postFileFolderActivity(String activityType, String path, NodeRef parentNodeRef, NodeRef nodeRef, String siteId, String name) {
        JSONObject json = this.createActivityJSON(this.getCurrentTenantDomain(), path, parentNodeRef, nodeRef, name);
        this.activityService.postActivity(activityType, siteId, APP_TOOL, json.toString());
    }

    private JSONObject createActivityJSON(String tenantDomain, String path, NodeRef parentNodeRef, NodeRef nodeRef, String fileName) {
        JSONObject json = new JSONObject();
        try {
            json.put("nodeRef", (Object)nodeRef);
            if (parentNodeRef != null) {
                json.put("parentNodeRef", (Object)parentNodeRef);
            }
            if (path != null) {
                json.put("page", (Object)("documentlibrary?path=" + path));
            } else {
                json.put("page", (Object)("document-details?nodeRef=" + nodeRef));
            }
            json.put("title", (Object)fileName);
            if (!tenantDomain.equals("")) {
                json.put("tenantDomain", (Object)tenantDomain);
            }
        }
        catch (JSONException error) {
            throw new AlfrescoRuntimeException("", (Throwable)error);
        }
        return json;
    }

    public static class ActivityInfo {
        private NodeRef nodeRef;
        private String parentPath;
        private NodeRef parentNodeRef;
        private String siteId;
        private String fileName;
        private boolean isFolder;

        public ActivityInfo(NodeRef nodeRef, String parentPath, NodeRef parentNodeRef, String siteId, String fileName, boolean isFolder) {
            this.nodeRef = nodeRef;
            this.parentPath = parentPath;
            this.parentNodeRef = parentNodeRef;
            this.siteId = siteId;
            this.fileName = fileName;
            this.isFolder = isFolder;
        }

        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public String getParentPath() {
            return this.parentPath;
        }

        public NodeRef getParentNodeRef() {
            return this.parentNodeRef;
        }

        public String getSiteId() {
            return this.siteId;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isFolder() {
            return this.isFolder;
        }
    }
}

