/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.util.Map;
import org.alfresco.opencmis.AlfrescoCmisExceptionInterceptor;
import org.alfresco.opencmis.AlfrescoCmisService;
import org.alfresco.opencmis.AlfrescoCmisServiceImpl;
import org.alfresco.opencmis.AlfrescoCmisServiceInterceptor;
import org.alfresco.opencmis.AlfrescoCmisStreamInterceptor;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionInterceptor;
import org.alfresco.service.cmr.security.AuthorityService;
import org.aopalliance.aop.Advice;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.support.CmisServiceWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;

public class AlfrescoCmisServiceFactory
extends AbstractServiceFactory {
    private static final Log logger = LogFactory.getLog(AlfrescoCmisServiceFactory.class);
    private CMISConnector connector;
    private RetryingTransactionInterceptor cmisTransactions;
    private AlfrescoCmisExceptionInterceptor cmisExceptions;
    private AlfrescoCmisServiceInterceptor cmisControl;
    private AlfrescoCmisStreamInterceptor cmisStreams;
    private AuthorityService authorityService;

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setCmisConnector(CMISConnector connector) {
        this.connector = connector;
    }

    public void setCmisTransactions(RetryingTransactionInterceptor cmisTransactions) {
        this.cmisTransactions = cmisTransactions;
    }

    public void setCmisExceptions(AlfrescoCmisExceptionInterceptor cmisExceptions) {
        this.cmisExceptions = cmisExceptions;
    }

    public void setCmisControl(AlfrescoCmisServiceInterceptor cmisControl) {
        this.cmisControl = cmisControl;
    }

    public void setCmisStreams(AlfrescoCmisStreamInterceptor cmisStreams) {
        this.cmisStreams = cmisStreams;
    }

    public void init(Map<String, String> parameters) {
    }

    public void init() {
    }

    public void destroy() {
    }

    public CmisService getService(CallContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\nCMIS getService(): \n   Authenticated as: " + AuthenticationUtil.getFullyAuthenticatedUser() + "\n" + "   Running as:       " + AuthenticationUtil.getRunAsUser() + "\n" + "   User:             " + context.getUsername() + "\n" + "   Repo:             " + context.getRepositoryId()));
        }
        if (AuthenticationUtil.getFullyAuthenticatedUser() != null && this.authorityService.isGuestAuthority(AuthenticationUtil.getFullyAuthenticatedUser())) {
            AuthenticationUtil.clearCurrentSecurityContext();
        }
        AlfrescoCmisService service = this.getCmisServiceTarget(this.connector);
        ProxyFactory proxyFactory = new ProxyFactory((Object)service);
        proxyFactory.addInterface(AlfrescoCmisService.class);
        proxyFactory.addAdvice((Advice)this.cmisExceptions);
        proxyFactory.addAdvice((Advice)this.cmisControl);
        proxyFactory.addAdvice((Advice)this.cmisStreams);
        proxyFactory.addAdvice((Advice)this.cmisTransactions);
        AlfrescoCmisService cmisService = (AlfrescoCmisService)proxyFactory.getProxy();
        CmisServiceWrapper wrapperService = new CmisServiceWrapper((CmisService)cmisService, this.connector.getTypesDefaultMaxItems(), this.connector.getTypesDefaultDepth(), this.connector.getObjectsDefaultMaxItems(), this.connector.getObjectsDefaultDepth());
        cmisService.open(context);
        return wrapperService;
    }

    protected AlfrescoCmisService getCmisServiceTarget(CMISConnector connector) {
        return new AlfrescoCmisServiceImpl(connector);
    }
}

