/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.constraint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.constraint.BaseParameterConstraint;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

public class FolderContentsParameterConstraint
extends BaseParameterConstraint {
    private NodeService nodeService;
    private SearchService searchService;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private Repository repository;
    private String searchPath;
    private List<String> nodeInclusionFilter = Collections.emptyList();

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setSearchPath(String searchPath) {
        this.searchPath = searchPath;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setNodeInclusionFilter(List<String> nodeInclusionFilter) {
        this.nodeInclusionFilter = new ArrayList<String>(nodeInclusionFilter.size());
        for (String extension : nodeInclusionFilter) {
            StringBuilder dotExt = new StringBuilder().append(".").append(extension);
            this.nodeInclusionFilter.add(dotExt.toString());
        }
    }

    @Override
    protected Map<String, String> getAllowableValuesImpl() {
        List nodeRefs = this.searchService.selectNodes(this.repository.getRootHome(), this.searchPath, null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef rootFolder = null;
        if (nodeRefs.size() == 0) {
            throw new AlfrescoRuntimeException("The path '" + this.searchPath + "' did not return any results.");
        }
        rootFolder = (NodeRef)nodeRefs.get(0);
        HashMap<String, String> result = new HashMap<String, String>(23);
        this.buildMap(result, rootFolder);
        return result;
    }

    private void buildMap(Map<String, String> result, NodeRef folderNodeRef) {
        List assocs = this.nodeService.getChildAssocs(folderNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef assoc : assocs) {
            NodeRef nodeRef = assoc.getChildRef();
            QName className = this.nodeService.getType(nodeRef);
            if (this.dictionaryService.isSubClass(className, ContentModel.TYPE_CONTENT)) {
                if (!this.isCmNameAcceptable(nodeRef)) continue;
                String title = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TITLE));
                if (title != null && title.length() > 0) {
                    result.put(nodeRef.toString(), title);
                    continue;
                }
                result.put(nodeRef.toString(), (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME)));
                continue;
            }
            if (!this.dictionaryService.isSubClass(className, ContentModel.TYPE_FOLDER)) continue;
            this.buildMap(result, nodeRef);
        }
    }

    private boolean isCmNameAcceptable(NodeRef nodeRef) {
        boolean result = true;
        if (!this.nodeInclusionFilter.isEmpty()) {
            result = false;
            String cmName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            for (String extension : this.nodeInclusionFilter) {
                if (!cmName.endsWith(extension)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

