/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.List;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleServiceException;

public class CopyActionExecuter
extends ActionExecuterAbstractBase {
    public static final String ERR_OVERWRITE = "Unable to overwrite copy because more than one have been found.";
    public static final String NAME = "copy";
    public static final String PARAM_DESTINATION_FOLDER = "destination-folder";
    public static final String PARAM_DEEP_COPY = "deep-copy";
    public static final String PARAM_OVERWRITE_COPY = "overwrite-copy";
    private CopyService copyService;
    private NodeService nodeService;
    private CheckOutCheckInService checkOutCheckInService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_DESTINATION_FOLDER, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_DESTINATION_FOLDER)));
        paramList.add(new ParameterDefinitionImpl(PARAM_DEEP_COPY, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_DEEP_COPY)));
        paramList.add(new ParameterDefinitionImpl(PARAM_OVERWRITE_COPY, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_OVERWRITE_COPY)));
    }

    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        if (!this.nodeService.exists(actionedUponNodeRef)) {
            return;
        }
        NodeRef destinationParent = (NodeRef)ruleAction.getParameterValue(PARAM_DESTINATION_FOLDER);
        boolean deepCopy = false;
        Boolean deepCopyValue = (Boolean)ruleAction.getParameterValue(PARAM_DEEP_COPY);
        if (deepCopyValue != null) {
            deepCopy = deepCopyValue;
        }
        boolean overwrite = true;
        Boolean overwriteValue = (Boolean)ruleAction.getParameterValue(PARAM_OVERWRITE_COPY);
        if (overwriteValue != null) {
            overwrite = overwriteValue;
        }
        NodeRef copyNodeRef = null;
        if (overwrite) {
            PagingResults<CopyService.CopyInfo> copies = this.copyService.getCopies(actionedUponNodeRef, destinationParent, new PagingRequest(1000));
            for (CopyService.CopyInfo copyInfo : copies.getPage()) {
                NodeRef copy = copyInfo.getNodeRef();
                if (this.checkOutCheckInService.isWorkingCopy(copy)) continue;
                if (copyNodeRef == null) {
                    copyNodeRef = copy;
                    continue;
                }
                throw new RuleServiceException(ERR_OVERWRITE);
            }
        }
        if (copyNodeRef != null) {
            this.copyService.copy(actionedUponNodeRef, copyNodeRef);
        } else {
            ChildAssociationRef originalAssoc = this.nodeService.getPrimaryParent(actionedUponNodeRef);
            this.copyService.copyAndRename(actionedUponNodeRef, destinationParent, originalAssoc.getTypeQName(), originalAssoc.getQName(), deepCopy);
        }
    }
}

