/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.ActivitiesFeedModelBuilder;
import org.alfresco.repo.activities.feed.FeedNotifier;
import org.alfresco.repo.activities.feed.UserNotifier;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ModelUtil;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.springframework.beans.factory.ObjectFactory;

public abstract class AbstractUserNotifier
implements UserNotifier {
    protected static Log logger = LogFactory.getLog(FeedNotifier.class);
    protected ActivityService activityService;
    protected NamespaceService namespaceService;
    protected RepoAdminService repoAdminService;
    protected NodeService nodeService;
    protected SiteService siteService;
    protected ObjectFactory<ActivitiesFeedModelBuilder> activitiesFeedModelBuilderFactory;

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setActivitiesFeedModdelBuilderFactory(ObjectFactory<ActivitiesFeedModelBuilder> activitivitesFeedModelBuilderFactory) {
        this.activitiesFeedModelBuilderFactory = activitivitesFeedModelBuilderFactory;
    }

    protected void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"activitiesFeedModdelBuilderFactory", this.activitiesFeedModelBuilderFactory);
        PropertyCheck.mandatory((Object)this, (String)"activityService", (Object)this.activityService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"siteService", (Object)this.siteService);
    }

    protected abstract boolean skipUser(NodeRef var1);

    protected abstract Long getFeedId(NodeRef var1);

    protected abstract void notifyUser(NodeRef var1, String var2, Object[] var3, Map<String, Object> var4, String var5);

    private void addSiteName(String siteId, Map<String, String> siteNames) {
        if (siteId == null) {
            return;
        }
        String siteName = siteNames.get(siteId);
        if (siteName == null) {
            SiteInfo site = this.siteService.getSite(siteId);
            if (site == null) {
                return;
            }
            String siteTitle = site.getTitle();
            siteName = siteTitle != null && siteTitle.length() > 0 ? siteTitle : siteId;
            siteNames.put(siteId, siteName);
        }
    }

    @Override
    public Pair<Integer, Long> notifyUser(NodeRef personNodeRef, String subject, Object[] subjectParams, Map<String, String> siteNames, String shareUrl, int repeatIntervalMins, String templateNodeRef) {
        List<ActivityFeedEntity> feedEntries;
        Map personProps = this.nodeService.getProperties(personNodeRef);
        String feedUserId = (String)personProps.get(ContentModel.PROP_USERNAME);
        if (this.skipUser(personNodeRef)) {
            return null;
        }
        Long feedDBID = this.getFeedId(personNodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Get user feed entries: " + feedUserId + ", " + feedDBID));
        }
        if ((feedEntries = this.activityService.getUserFeedEntries(feedUserId, null, false, false, null, null, feedDBID)).size() > 0) {
            ActivitiesFeedModelBuilder modelBuilder;
            try {
                modelBuilder = (ActivitiesFeedModelBuilder)this.activitiesFeedModelBuilderFactory.getObject();
            }
            catch (Exception error) {
                logger.warn((Object)("Unable to create model builder: " + error.getMessage()));
                return null;
            }
            for (ActivityFeedEntity feedEntry : feedEntries) {
                try {
                    modelBuilder.addAcctivitiyFeedEntry(feedEntry);
                    String siteId = feedEntry.getSiteNetwork();
                    this.addSiteName(siteId, siteNames);
                }
                catch (JSONException je) {
                    logger.warn((Object)("Skip feed entry for user (" + feedUserId + "): " + je.getMessage()));
                }
            }
            int activityCount = modelBuilder.activityCount();
            if (activityCount > 0) {
                Map<String, Object> model = modelBuilder.buildModel();
                model.put("siteTitles", siteNames);
                model.put("repeatIntervalMins", repeatIntervalMins);
                model.put("feedItemsMax", this.activityService.getMaxFeedItems());
                model.put("productName", ModelUtil.getProductName(this.repoAdminService));
                HashMap personPrefixProps = new HashMap(personProps.size());
                for (QName propQName : personProps.keySet()) {
                    try {
                        String propPrefix = propQName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
                        personPrefixProps.put(propPrefix, personProps.get(propQName));
                    }
                    catch (NamespaceException ne) {
                        logger.warn((Object)("Ignoring property '" + propQName + "' as it's namespace is not registered"));
                    }
                }
                model.put("personProps", personPrefixProps);
                this.notifyUser(personNodeRef, subject, subjectParams, model, templateNodeRef);
                return new Pair((Object)activityCount, (Object)modelBuilder.getMaxFeedId());
            }
        }
        return null;
    }
}

