/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class Log4JHierarchyInit
implements ApplicationContextAware {
    private static Log logger = LogFactory.getLog(Log4JHierarchyInit.class);
    private List<String> extraLog4jUrls;
    private ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    public Log4JHierarchyInit() {
        this.extraLog4jUrls = new ArrayList<String>();
    }

    public void setExtraLog4jUrls(List<String> urls) {
        for (String url : urls) {
            this.extraLog4jUrls.add(url);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.resolver = applicationContext;
    }

    public void init() {
        this.importLogSettings();
    }

    private void importLogSettings() {
        try {
            Class<?> clazz = Class.forName("org.apache.log4j.PropertyConfigurator");
            Method method = clazz.getMethod("configure", URL.class);
            for (String url : this.extraLog4jUrls) {
                this.importLogSettings(method, url);
            }
        }
        catch (ClassNotFoundException e) {
            return;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find method 'configure' on class 'org.apache.log4j.PropertyConfigurator'");
        }
    }

    private void importLogSettings(Method method, String springUrl) {
        Resource[] resources = null;
        try {
            resources = this.resolver.getResources(springUrl);
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to find additional Logger configuration: " + springUrl));
        }
        for (Resource resource : resources) {
            try {
                URL url = resource.getURL();
                method.invoke(null, url);
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Failed to add extra Logger configuration: \n   URL:   " + springUrl + "\n" + "   Error: " + e.getMessage()), e);
            }
        }
    }
}

