/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.admin.patch.PatchExecuter;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class AuthorityDefaultZonesPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.authorityDefaultZonesPatch.result";
    private static final String MSG_UPDATE_USERS = "patch.authorityDefaultZonesPatch.users";
    private static final String MSG_UPDATE_GROUPS = "patch.authorityDefaultZonesPatch.groups";
    private static Log progress_logger = LogFactory.getLog(PatchExecuter.class);
    private AuthorityService authorityService;
    private AVMService avmService;
    private SiteService siteService;

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    @Override
    protected String applyInternal() throws Exception {
        int count = 0;
        int total = this.authorityService.getAllAuthorities(AuthorityType.USER).size() + this.authorityService.getAllAuthorities(AuthorityType.GROUP).size();
        this.reportProgress(total, count);
        String msg = I18NUtil.getMessage((String)MSG_UPDATE_USERS);
        progress_logger.info((Object)msg);
        count = this.setZonesForPeople(total, count);
        msg = I18NUtil.getMessage((String)MSG_UPDATE_GROUPS);
        progress_logger.info((Object)msg);
        this.setZonesForGroups(total, count);
        return MSG_SUCCESS;
    }

    private int setZonesForPeople(int total, int start) {
        HashSet<String> defaultZones = new HashSet<String>(2, 1.0f);
        defaultZones.add("APP.DEFAULT");
        defaultZones.add("AUTH.ALF");
        ArrayList<Action> personActions = new ArrayList<Action>(1);
        personActions.add(new Action(null, defaultZones, ActionType.SET));
        return this.setZones(AuthorityType.USER, personActions, total, start);
    }

    private int setZonesForGroups(int total, int start) {
        HashSet<String> defaultZones = new HashSet<String>(2, 1.0f);
        defaultZones.add("APP.DEFAULT");
        defaultZones.add("AUTH.ALF");
        HashSet<String> wcmZones = new HashSet<String>(2, 1.0f);
        wcmZones.add("APP.WCM");
        wcmZones.add("AUTH.ALF");
        HashSet<String> shareZones = new HashSet<String>(2, 1.0f);
        shareZones.add("APP.SHARE");
        shareZones.add("AUTH.ALF");
        List<AVMStoreDescriptor> stores = this.avmService.getStores();
        List<SiteInfo> sites = this.siteService.listSites(null, null);
        ArrayList<Action> groupActions = new ArrayList<Action>(stores.size() * 4 + sites.size() * 5 + 1);
        for (AVMStoreDescriptor store : stores) {
            groupActions.add(new Action("GROUP_" + store.getName() + "-ContentManager", wcmZones, ActionType.SET));
            groupActions.add(new Action("GROUP_" + store.getName() + "-ContentPublisher", wcmZones, ActionType.SET));
            groupActions.add(new Action("GROUP_" + store.getName() + "-ContentContributor", wcmZones, ActionType.SET));
            groupActions.add(new Action("GROUP_" + store.getName() + "-ContentReviewer", wcmZones, ActionType.SET));
        }
        for (SiteInfo site : sites) {
            groupActions.add(new Action("GROUP_site_" + site.getShortName(), shareZones, ActionType.SET));
            groupActions.add(new Action("GROUP_site_" + site.getShortName() + "_SiteManager", shareZones, ActionType.SET));
            groupActions.add(new Action("GROUP_site_" + site.getShortName() + "_SiteCollaborator", shareZones, ActionType.SET));
            groupActions.add(new Action("GROUP_site_" + site.getShortName() + "_SiteContributor", shareZones, ActionType.SET));
            groupActions.add(new Action("GROUP_site_" + site.getShortName() + "_SiteConsumer", shareZones, ActionType.SET));
        }
        groupActions.add(new Action(null, defaultZones, ActionType.SET));
        return this.setZones(AuthorityType.GROUP, groupActions, total, start);
    }

    private int setZones(AuthorityType authorityType, List<Action> actions, int total, int start) {
        int count = start;
        Set<String> authorities = this.authorityService.getAllAuthorities(authorityType);
        for (String authority : authorities) {
            for (Action action : actions) {
                if (action.name != null) {
                    if (!action.name.equals(authority)) continue;
                    this.fixAuthority(action.actionType, action.zones, authority);
                    break;
                }
                this.fixAuthority(action.actionType, action.zones, authority);
                break;
            }
            this.reportProgress(total, ++count);
        }
        return count;
    }

    private void fixAuthority(ActionType actionType, Set<String> zones, String authority) {
        switch (actionType) {
            case ADD: {
                this.authorityService.addAuthorityToZones(authority, zones);
                break;
            }
            case SET: {
                Set<String> current = this.authorityService.getAuthorityZones(authority);
                this.authorityService.removeAuthorityFromZones(authority, current);
                this.authorityService.addAuthorityToZones(authority, zones);
                break;
            }
            case SET_IF_UNSET: {
                Set<String> current = this.authorityService.getAuthorityZones(authority);
                if (current.size() != 0) break;
                this.authorityService.addAuthorityToZones(authority, zones);
            }
        }
    }

    private static class Action {
        String name;
        Set<String> zones;
        ActionType actionType;

        Action(String name, Set<String> zones, ActionType actionType) {
            this.name = name;
            this.zones = zones;
            this.actionType = actionType;
        }
    }

    private static enum ActionType {
        ADD,
        SET,
        SET_IF_UNSET;

    }
}

