/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.I18NUtil;

public class CalendarModelUriPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.calendarModelNamespacePatch.result";
    private static final String URI_BEFORE = "com.infoaxon.alfresco.calendar";
    private static final String URI_AFTER = "http://www.alfresco.org/model/calendar";
    private QNameDAO qnameDAO;
    private PatchDAO patchDAO;
    private NodeDAO nodeDAO;
    private RetryingTransactionHelper retryingTransactionHelper;
    private static long BATCH_SIZE = 100000L;

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.patchDAO, "patchDAO");
        this.checkPropertyNotNull(this.qnameDAO, "qnameDAO");
        this.checkPropertyNotNull(this.nodeDAO, "nodeDAO");
        this.checkPropertyNotNull(this.retryingTransactionHelper, "retryingTransactionHelper");
    }

    @Override
    protected String applyInternal() throws Exception {
        Long maxNodeId = this.patchDAO.getMaxAdmNodeID();
        long count = 0L;
        Pair<Long, String> before = this.qnameDAO.getOrCreateNamespace(URI_BEFORE);
        Long i = 0L;
        while (i < maxNodeId) {
            Work work = new Work((Long)before.getFirst(), i);
            count += (long)this.retryingTransactionHelper.doInTransaction(work, false, true).intValue();
            i = i + BATCH_SIZE;
        }
        this.qnameDAO.updateNamespace(URI_BEFORE, URI_AFTER);
        return I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{count});
    }

    private class Work
    implements RetryingTransactionHelper.RetryingTransactionCallback<Integer> {
        long nsId;
        long lower;

        Work(long nsId, long lower) {
            this.nsId = nsId;
            this.lower = lower;
        }

        @Override
        public Integer execute() throws Throwable {
            List<Long> nodeIds = CalendarModelUriPatch.this.patchDAO.getNodesByTypeUriId(this.nsId, this.lower, this.lower + BATCH_SIZE);
            CalendarModelUriPatch.this.nodeDAO.touchNodes(CalendarModelUriPatch.this.nodeDAO.getCurrentTransactionId(true), nodeIds);
            return nodeIds.size();
        }
    }
}

