/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.Map;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class DmPermissionsPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.updateDmPermissions.result";
    private static Log logger = LogFactory.getLog(DmPermissionsPatch.class);
    private AccessControlListDAO accessControlListDao;
    private PatchDAO patchDAO;
    private ControlDAO controlDAO;

    public void setAccessControlListDao(AccessControlListDAO accessControlListDao) {
        this.accessControlListDao = accessControlListDao;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setControlDAO(ControlDAO controlDAO) {
        this.controlDAO = controlDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String applyInternal() throws Exception {
        Thread progressThread = null;
        progressThread = new Thread((Runnable)new ProgressWatcher(), "DMPatchProgressWatcher");
        progressThread.start();
        try {
            String msg;
            Map<ACLType, Integer> summary = this.accessControlListDao.patchAcls();
            String string = msg = I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{summary.get((Object)ACLType.DEFINING)});
            return string;
        }
        finally {
            progressThread.interrupt();
            progressThread.join();
        }
    }

    private class ProgressWatcher
    implements Runnable {
        private boolean running = true;
        Long toDo;
        Long max;

        private ProgressWatcher() {
        }

        @Override
        public void run() {
            while (this.running) {
                if (this.running) {
                    RetryingTransactionHelper txHelper = DmPermissionsPatch.this.transactionService.getRetryingTransactionHelper();
                    txHelper.setMaxRetries(1);
                    txHelper.setForceWritable(true);
                    RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                        @Override
                        public Long execute() throws Throwable {
                            try {
                                DmPermissionsPatch.this.controlDAO.setTransactionIsolationLevel(1);
                            }
                            catch (IllegalStateException e) {
                                ProgressWatcher.this.toDo = 0L;
                                ProgressWatcher.this.running = false;
                                return 0L;
                            }
                            if (ProgressWatcher.this.toDo == null) {
                                ProgressWatcher.this.toDo = DmPermissionsPatch.this.patchDAO.getDmNodeCount();
                                ProgressWatcher.this.max = DmPermissionsPatch.this.patchDAO.getMaxAclId();
                            }
                            return DmPermissionsPatch.this.patchDAO.getDmNodeCountWithNewACLs(ProgressWatcher.this.max);
                        }
                    };
                    try {
                        Long done = txHelper.doInTransaction(callback, true, true);
                        DmPermissionsPatch.this.reportProgress(this.toDo, done);
                    }
                    catch (Throwable e) {
                        logger.error((Object)"Failure in ProgressWatcher", e);
                        this.running = false;
                    }
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    this.running = false;
                }
            }
        }
    }
}

