/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.I18NUtil;

public class ImapUnsubscribedAspectPatch
extends AbstractPatch {
    private static final String MSG_NONSUBSCRIBED_ASPECT_REMOVED = "patch.imapUnsubscribedAspect.result.removed";
    private static final QName ASPECT_NON_SUBSCRIBED = QName.createQName((String)"{http://www.alfresco.org/model/imap/1.0}nonSubscribed");
    private NodeDAO nodeDAO;
    private PatchDAO patchDAO;
    private PersonService personService;
    private final int batchThreads = 3;
    private final int batchSize = 40;
    private final long count = 120L;
    private long minSearchNodeId = 1L;

    @Override
    protected String applyInternal() throws Exception {
        final List users = this.nodeService.getChildAssocs(this.personService.getPeopleContainer(), (QNamePattern)ContentModel.ASSOC_CHILDREN, RegexQNamePattern.MATCH_ALL);
        final long maxNodeId = this.patchDAO.getMaxAdmNodeID();
        BatchProcessWorkProvider<NodeRef> workProvider = new BatchProcessWorkProvider<NodeRef>(){
            final List<NodeRef> result = new ArrayList<NodeRef>();

            @Override
            public int getTotalEstimatedWorkSize() {
                return this.result.size();
            }

            @Override
            public Collection<NodeRef> getNextWork() {
                this.result.clear();
                while (this.result.isEmpty() && ImapUnsubscribedAspectPatch.this.minSearchNodeId < maxNodeId) {
                    ImapUnsubscribedAspectPatch.this.nodeDAO.getNodesWithAspects(Collections.singleton(ASPECT_NON_SUBSCRIBED), ImapUnsubscribedAspectPatch.this.minSearchNodeId, ImapUnsubscribedAspectPatch.this.minSearchNodeId + 120L, new NodeDAO.NodeRefQueryCallback(){

                        @Override
                        public boolean handle(Pair<Long, NodeRef> nodePair) {
                            result.add((NodeRef)nodePair.getSecond());
                            return true;
                        }
                    });
                    ImapUnsubscribedAspectPatch.this.minSearchNodeId = ImapUnsubscribedAspectPatch.this.minSearchNodeId + 120L + 1L;
                }
                return this.result;
            }
        };
        BatchProcessor<NodeRef> batchProcessor = new BatchProcessor<NodeRef>("ImapUnsubscribedAspectPatch", this.transactionService.getRetryingTransactionHelper(), workProvider, 3, 40, this.applicationEventPublisher, null, 1000);
        BatchProcessor.BatchProcessWorker<NodeRef> worker = new BatchProcessor.BatchProcessWorker<NodeRef>(){

            @Override
            public void afterProcess() throws Throwable {
            }

            @Override
            public void beforeProcess() throws Throwable {
            }

            @Override
            public String getIdentifier(NodeRef entry) {
                return entry.toString();
            }

            @Override
            public void process(NodeRef entry) throws Throwable {
                ImapUnsubscribedAspectPatch.this.nodeService.removeAspect(entry, ImapModel.ASPECT_IMAP_FOLDER_NONSUBSCRIBED);
                for (ChildAssociationRef userRef : users) {
                    ImapUnsubscribedAspectPatch.this.nodeService.createAssociation(userRef.getChildRef(), entry, ImapModel.ASSOC_IMAP_UNSUBSCRIBED);
                }
            }
        };
        batchProcessor.process(worker, true);
        return I18NUtil.getMessage((String)MSG_NONSUBSCRIBED_ASPECT_REMOVED);
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

