/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class DisableAuditableBehaviourInterceptor
implements MethodInterceptor {
    private BehaviourFilter behaviourFilter;
    private Set<String> methodNames = new HashSet<String>(0);
    private Set<QName> argumentQNameValues = new HashSet<QName>(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String methodName = methodInvocation.getMethod().getName();
        Object[] args = methodInvocation.getArguments();
        ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
        if (args.length > 0) {
            if (args[0] instanceof NodeRef) {
                nodes.add((NodeRef)args[0]);
            } else if (args[0] instanceof Collection) {
                nodes.addAll((Collection)args[0]);
            }
        }
        QName arg1 = null;
        if (args.length > 1 && args[1] instanceof QName) {
            arg1 = (QName)args[1];
        }
        if (this.behaviourFilter != null && this.methodNames.contains(methodName) && (arg1 == null || this.argumentQNameValues.contains(arg1))) {
            HashSet<NodeRef> disabledNodeRefs = new HashSet<NodeRef>();
            for (NodeRef nodeRef : nodes) {
                if (disabledNodeRefs.contains(nodeRef) || !this.behaviourFilter.isEnabled(nodeRef, ContentModel.ASPECT_AUDITABLE)) continue;
                this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                disabledNodeRefs.add(nodeRef);
            }
            try {
                Object object = methodInvocation.proceed();
                return object;
            }
            finally {
                for (NodeRef nodeRef : nodes) {
                    if (!disabledNodeRefs.contains(nodeRef)) continue;
                    this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                }
            }
        }
        return methodInvocation.proceed();
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setMethodNames(List<String> methodNames) {
        this.methodNames = new HashSet<String>(methodNames);
    }

    public void setArgumentValues(List<String> argumentValues) {
        this.argumentQNameValues = new HashSet<QName>(argumentValues.size() * 2 + 1);
        for (String argumentValue : argumentValues) {
            QName argumentQNameValue = QName.createQName((String)argumentValue);
            this.argumentQNameValues.add(argumentQNameValue);
        }
    }
}

