/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.Calendar;
import java.util.Date;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AVMDeploymentAttemptCleaner {
    protected long maxAge = 180L;
    protected NodeService nodeService;
    protected TransactionService transactionService;
    protected SearchService searchService;
    protected ImporterBootstrap importerBootstrap;
    private static Log logger = LogFactory.getLog(AVMDeploymentAttemptCleaner.class);

    public void setMaxAge(long maxAge) {
        this.maxAge = new Long(maxAge);
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void execute() {
        AuthenticationUtil.RunAsWork<String> authorisedWork = new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                RetryingTransactionHelper.RetryingTransactionCallback<String> expiredContentWork = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                    @Override
                    public String execute() throws Exception {
                        AVMDeploymentAttemptCleaner.this.cleanAttempts();
                        return null;
                    }
                };
                return AVMDeploymentAttemptCleaner.this.transactionService.getRetryingTransactionHelper().doInTransaction(expiredContentWork);
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)authorisedWork, (String)AuthenticationUtil.getAdminUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAttempts() {
        long daysInMs = 86400000L * this.maxAge;
        Date toDate = new Date(new Date().getTime() - daysInMs);
        Calendar cal = Calendar.getInstance();
        cal.setTime(toDate);
        StringBuilder query = new StringBuilder("@");
        query.append("wca");
        query.append("\\:");
        query.append(WCMAppModel.PROP_DEPLOYATTEMPTTIME.getLocalName());
        query.append(":[0001\\-01\\-01T00:00:00 TO ");
        query.append(cal.get(1));
        query.append("\\-");
        query.append(cal.get(2) + 1);
        query.append("\\-");
        query.append(cal.get(5));
        query.append("T00:00:00]");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Finding old deploymentattempt nodes using query: " + query.toString()));
        }
        try (ResultSet results = null;){
            results = this.searchService.query(this.importerBootstrap.getStoreRef(), "lucene", query.toString());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleting " + results.length() + " old deployment attempts"));
            }
            for (NodeRef attempt : results.getNodeRefs()) {
                this.nodeService.deleteNode(attempt);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Deleted deployment attempt: " + attempt));
            }
        }
    }
}

