/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.WCMAppModel;
import org.alfresco.model.WCMModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LayeredFolderType
implements NodeServicePolicies.OnMoveNodePolicy {
    private static Log logger = LogFactory.getLog(LayeredFolderType.class);
    private PolicyComponent policyComponent;
    private FileFolderService fileFolderService;
    private transient AVMService avmService;
    private static ThreadLocal<Boolean> issuedByWebClient = new ThreadLocal();
    private static long EXTERNAL_MAX_TIME = 2000L;
    private long maxTime = EXTERNAL_MAX_TIME;

    public void init() {
        if (this.maxTime < 0L) {
            logger.warn((Object)("Unable to set 'wcm.rename.max.time.milliseconds' property value: '" + this.maxTime + " ms', " + "set default value: '" + EXTERNAL_MAX_TIME + " ms'"));
            this.setMaxTime(EXTERNAL_MAX_TIME);
        }
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.fileFolderService);
        PropertyCheck.mandatory((Object)this, (String)"avmService", (Object)this.avmService);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, WCMModel.TYPE_AVM_LAYERED_FOLDER, (Behaviour)new JavaBehaviour(this, "onMoveNode", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    @Override
    public synchronized void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        long startTime = System.currentTimeMillis();
        NodeRef oldNodeRef = oldChildAssocRef.getChildRef();
        NodeRef newNodeRef = newChildAssocRef.getChildRef();
        String name = newChildAssocRef.getQName().getLocalName();
        String[] splittedPath = AVMUtil.splitPath((String)AVMNodeConverter.ToAVMVersionPath(oldNodeRef).getSecond());
        String avmStore = splittedPath[0];
        String oldPathToReplace = splittedPath[1];
        String newPathToInsert = oldPathToReplace.substring(0, oldPathToReplace.lastIndexOf(47) + 1) + name;
        AVMNodeDescriptor desc = this.avmService.lookup(-1, (String)AVMNodeConverter.ToAVMVersionPath(newNodeRef).getSecond());
        if (desc.isDirectory()) {
            ArrayList<AVMNodeDescriptor> descriptors = new ArrayList<AVMNodeDescriptor>(10);
            descriptors.add(desc);
            ArrayList<AVMNodeDescriptor> nextDescriptors = new ArrayList<AVMNodeDescriptor>(10);
            while (descriptors.size() != 0) {
                if (nextDescriptors != null) {
                    nextDescriptors.clear();
                }
                for (AVMNodeDescriptor curDescriptor : descriptors) {
                    SortedMap<String, AVMNodeDescriptor> listing = this.avmService.getDirectoryListing(curDescriptor);
                    if (listing.size() == 0) continue;
                    for (AVMNodeDescriptor descriptor : listing.values()) {
                        if (descriptor.isDirectory()) {
                            nextDescriptors.add(descriptor);
                            continue;
                        }
                        if (!descriptor.isFile()) continue;
                        this.refreshPath(descriptor, avmStore, oldPathToReplace, newPathToInsert, startTime);
                    }
                }
                descriptors.clear();
                if (nextDescriptors == null) continue;
                descriptors.addAll(nextDescriptors);
            }
        }
    }

    private void refreshPath(AVMNodeDescriptor descriptor, String avmStore, String oldPathToReplace, String newPathToInsert, long startTime) {
        this.checkDuration(startTime);
        String path = descriptor.getPath();
        if (this.avmService.hasAspect(-1, path, WCMAppModel.ASPECT_FORM_INSTANCE_DATA)) {
            this.refreshFormInstanceData(avmStore, oldPathToReplace, newPathToInsert, -1, path);
        } else if (this.avmService.hasAspect(-1, path, WCMAppModel.ASPECT_RENDITION)) {
            this.refreshRendition(avmStore, oldPathToReplace, newPathToInsert, -1, path);
        }
    }

    private void refreshFormInstanceData(String avmStore, String pathToReplace, String pathToInsert, int nodeVersion, String nodePath) {
        PropertyValue pv = this.avmService.getNodeProperty(nodeVersion, nodePath, WCMAppModel.PROP_RENDITIONS);
        if (pv == null) {
            return;
        }
        Collection<Serializable> renditionPaths = pv.getCollection(DataTypeDefinition.TEXT);
        ArrayList<String> newRenditionPaths = new ArrayList<String>(renditionPaths.size());
        for (Serializable renditionPath : renditionPaths) {
            String oldPath = (String)((Object)renditionPath);
            String newPath = oldPath.replaceFirst(pathToReplace, pathToInsert);
            newRenditionPaths.add(newPath);
            String fullRenditionPath = avmStore + ":" + newPath;
            String primaryFormInstanceData = this.avmService.getNodeProperty(-1, fullRenditionPath, WCMAppModel.PROP_PRIMARY_FORM_INSTANCE_DATA).getStringValue();
            primaryFormInstanceData = primaryFormInstanceData.replaceFirst(pathToReplace, pathToInsert);
            this.avmService.setNodeProperty(fullRenditionPath, WCMAppModel.PROP_PRIMARY_FORM_INSTANCE_DATA, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)primaryFormInstanceData)));
        }
        this.avmService.setNodeProperty(nodePath, WCMAppModel.PROP_RENDITIONS, new PropertyValue(DataTypeDefinition.TEXT, newRenditionPaths));
    }

    private void refreshRendition(String avmStore, String pathToReplace, String pathToInsert, int nodeVersion, String nodePath) {
        String primaryFormInstanceData = this.avmService.getNodeProperty(nodeVersion, nodePath, WCMAppModel.PROP_PRIMARY_FORM_INSTANCE_DATA).getStringValue();
        if (primaryFormInstanceData.startsWith(pathToReplace + '/')) {
            return;
        }
        if (primaryFormInstanceData.startsWith(pathToInsert + '/')) {
            return;
        }
        PropertyValue pv = this.avmService.getNodeProperty(-1, avmStore + ":" + primaryFormInstanceData, WCMAppModel.PROP_RENDITIONS);
        if (pv == null) {
            return;
        }
        Collection<Serializable> renditionPaths = pv.getCollection(DataTypeDefinition.TEXT);
        ArrayList<String> newRenditionPaths = new ArrayList<String>(renditionPaths.size());
        for (Serializable renditionPath : renditionPaths) {
            if (((String)((Object)renditionPath)).startsWith(pathToInsert)) {
                return;
            }
            String newPath = ((String)((Object)renditionPath)).replaceFirst(pathToReplace, pathToInsert);
            newRenditionPaths.add(newPath);
        }
        this.avmService.setNodeProperty(avmStore + ":" + primaryFormInstanceData, WCMAppModel.PROP_RENDITIONS, new PropertyValue(DataTypeDefinition.TEXT, newRenditionPaths));
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    private void checkDuration(long startTime) {
        if (!LayeredFolderType.isIssuedByWebClient().booleanValue() && System.currentTimeMillis() - startTime > this.maxTime) {
            logger.warn((Object)"Operation exceeds max time duration and was aborted");
            throw new AlfrescoRuntimeException("Operation exceeds max time duration and was aborted");
        }
    }

    public static void setIssuedByWebClient(Boolean isWebClient) {
        issuedByWebClient.set(isWebClient);
    }

    public static Boolean isIssuedByWebClient() {
        Boolean result = issuedByWebClient.get();
        return result == null ? Boolean.FALSE : result;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }
}

