/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.Serializable;
import org.alfresco.repo.avm.VersionLayeredNodeEntry;
import org.alfresco.repo.avm.VersionRoot;
import org.alfresco.util.MD5;

public class VersionLayeredNodeEntryImpl
implements VersionLayeredNodeEntry,
Serializable {
    private static final long serialVersionUID = -5222079271680056311L;
    private VersionRoot fVersion;
    private String fMD5Sum;
    private String fPath;

    public VersionLayeredNodeEntryImpl() {
    }

    public VersionLayeredNodeEntryImpl(VersionRoot version, String path) {
        this.fVersion = version;
        this.fMD5Sum = MD5.Digest((byte[])path.getBytes());
        this.fPath = path;
    }

    public void setPath(String path) {
        this.fPath = path;
    }

    @Override
    public String getPath() {
        return this.fPath;
    }

    public void setVersion(VersionRoot version) {
        this.fVersion = version;
    }

    @Override
    public VersionRoot getVersion() {
        return this.fVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionLayeredNodeEntry)) {
            return false;
        }
        VersionLayeredNodeEntry other = (VersionLayeredNodeEntry)obj;
        return this.fVersion.equals(other.getVersion()) && this.fMD5Sum.equals(other.getMd5Sum());
    }

    public int hashCode() {
        return this.fVersion.hashCode() + this.fMD5Sum.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[VersionLayeredNodeEntry:");
        builder.append(this.fVersion.toString());
        builder.append(':');
        builder.append(this.fPath);
        builder.append(']');
        return builder.toString();
    }

    @Override
    public String getMd5Sum() {
        return this.fMD5Sum;
    }

    public void setMd5Sum(String sum) {
        this.fMD5Sum = sum;
    }
}

