/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.actions;

import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AVMRevertStoreAction
extends ActionExecuterAbstractBase {
    private static Log fgLogger = LogFactory.getLog(AVMRevertStoreAction.class);
    public static final String NAME = "avm-revert-store";
    public static final String PARAM_VERSION = "version";
    private AVMSyncService fSyncService;

    public void setAvmSyncService(AVMSyncService service) {
        this.fSyncService = service;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        Pair<Integer, String> pathVersion = AVMNodeConverter.ToAVMVersionPath(actionedUponNodeRef);
        int revertVersion = (Integer)action.getParameterValue(PARAM_VERSION);
        List<AVMDifference> diffs = this.fSyncService.compare(revertVersion, (String)pathVersion.getSecond(), -1, (String)pathVersion.getSecond(), null);
        String message = "Reverted to Version " + revertVersion + ".";
        this.fSyncService.update(diffs, null, false, false, true, true, message, message);
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_VERSION, DataTypeDefinition.INT, true, this.getParamDisplayLabel(PARAM_VERSION)));
    }
}

