/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.ibatis;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.VersionRoot;
import org.alfresco.repo.avm.VersionRootDAO;
import org.alfresco.repo.avm.VersionRootImpl;
import org.alfresco.repo.domain.avm.AVMVersionRootEntity;

class VersionRootDAOIbatis
implements VersionRootDAO {
    VersionRootDAOIbatis() {
    }

    @Override
    public void save(VersionRoot vr) {
        AVMVersionRootEntity vrEntity = AVMDAOs.Instance().newAVMVersionRootDAO.createVersionRoot(vr.getAvmStore().getId(), vr.getRoot().getId(), vr.getVersionID(), vr.getCreator(), vr.getTag(), vr.getDescription());
        ((VersionRootImpl)vr).setId(vrEntity.getId());
    }

    @Override
    public void update(VersionRoot vr) {
        AVMDAOs.Instance().newAVMVersionRootDAO.updateVersionRoot(this.convertVersionRootToVersionRootEntity(vr));
    }

    @Override
    public void delete(VersionRoot vr) {
        AVMDAOs.Instance().newAVMVersionRootDAO.deleteVersionRoot(vr.getId());
    }

    @Override
    public List<VersionRoot> getAllInAVMStore(AVMStore store) {
        List<AVMVersionRootEntity> vrEntities = AVMDAOs.Instance().newAVMVersionRootDAO.getAllInStore(store.getId());
        ArrayList<VersionRoot> vrs = new ArrayList<VersionRoot>(vrEntities.size());
        for (AVMVersionRootEntity vrEntity : vrEntities) {
            vrs.add(this.convertVersionRootEntityToVersionRoot(vrEntity));
        }
        return vrs;
    }

    @Override
    public List<VersionRoot> getByDates(AVMStore store, Date from, Date to) {
        List<AVMVersionRootEntity> vrEntities = AVMDAOs.Instance().newAVMVersionRootDAO.getByDates(store.getId(), from, to);
        ArrayList<VersionRoot> vrs = new ArrayList<VersionRoot>(vrEntities.size());
        for (AVMVersionRootEntity vrEntity : vrEntities) {
            vrs.add(this.convertVersionRootEntityToVersionRoot(vrEntity));
        }
        return vrs;
    }

    @Override
    public synchronized VersionRoot getByVersionID(AVMStore store, int id) {
        AVMVersionRootEntity vrEntity = AVMDAOs.Instance().newAVMVersionRootDAO.getByVersionID(store.getId(), id);
        return this.convertVersionRootEntityToVersionRoot(vrEntity);
    }

    @Override
    public VersionRoot getByRoot(AVMNode root) {
        AVMVersionRootEntity vrEntity = AVMDAOs.Instance().newAVMVersionRootDAO.getByRoot(root.getId());
        return this.convertVersionRootEntityToVersionRoot(vrEntity);
    }

    @Override
    public VersionRoot getMaxVersion(AVMStore rep) {
        AVMVersionRootEntity vrEntity = AVMDAOs.Instance().newAVMVersionRootDAO.getMaxVersion(rep.getId());
        return this.convertVersionRootEntityToVersionRoot(vrEntity);
    }

    @Override
    public Integer getMaxVersionID(AVMStore store) {
        Long maxVersionId = AVMDAOs.Instance().newAVMVersionRootDAO.getMaxVersionID(store.getId());
        if (maxVersionId == null) {
            return null;
        }
        return new Integer(maxVersionId.intValue());
    }

    @Override
    public List<VersionRoot> getByVersionsTo(AVMStore store, int version) {
        List<AVMVersionRootEntity> vrEntities = AVMDAOs.Instance().newAVMVersionRootDAO.getByVersionsTo(store.getId(), version);
        ArrayList<VersionRoot> vrs = new ArrayList<VersionRoot>(vrEntities.size());
        for (AVMVersionRootEntity vrEntity : vrEntities) {
            vrs.add(this.convertVersionRootEntityToVersionRoot(vrEntity));
        }
        return vrs;
    }

    @Override
    public List<VersionRoot> getByVersionsFrom(AVMStore store, int version) {
        List<AVMVersionRootEntity> vrEntities = AVMDAOs.Instance().newAVMVersionRootDAO.getByVersionsFrom(store.getId(), version);
        ArrayList<VersionRoot> vrs = new ArrayList<VersionRoot>(vrEntities.size());
        for (AVMVersionRootEntity vrEntity : vrEntities) {
            vrs.add(this.convertVersionRootEntityToVersionRoot(vrEntity));
        }
        return vrs;
    }

    @Override
    public List<VersionRoot> getByVersionsBetween(AVMStore store, int startVersion, int endVersion) {
        List<AVMVersionRootEntity> vrEntities = AVMDAOs.Instance().newAVMVersionRootDAO.getByVersionsBetween(store.getId(), startVersion, endVersion);
        ArrayList<VersionRoot> vrs = new ArrayList<VersionRoot>(vrEntities.size());
        for (AVMVersionRootEntity vrEntity : vrEntities) {
            vrs.add(this.convertVersionRootEntityToVersionRoot(vrEntity));
        }
        return vrs;
    }

    private AVMVersionRootEntity convertVersionRootToVersionRootEntity(VersionRoot vr) {
        if (vr == null) {
            return null;
        }
        AVMVersionRootEntity vrEntity = new AVMVersionRootEntity();
        vrEntity.setCreatedDate(vr.getCreateDate());
        vrEntity.setCreator(vr.getCreator());
        vrEntity.setDescription(vr.getDescription());
        vrEntity.setId(vr.getId());
        vrEntity.setRootNodeId(vr.getRoot().getId());
        vrEntity.setStoreId(vr.getAvmStore().getId());
        vrEntity.setTag(vr.getTag());
        vrEntity.setVersion(vr.getVersionID());
        return vrEntity;
    }

    private VersionRoot convertVersionRootEntityToVersionRoot(AVMVersionRootEntity vrEntity) {
        if (vrEntity == null) {
            return null;
        }
        AVMStore store = AVMDAOs.Instance().fAVMStoreDAO.getByID(vrEntity.getStoreId());
        AVMNode rootNode = AVMDAOs.Instance().fAVMNodeDAO.getByID(vrEntity.getRootNodeId());
        VersionRootImpl vr = new VersionRootImpl(store, (DirectoryNode)rootNode, vrEntity.getVersion(), vrEntity.getCreatedDate(), vrEntity.getCreator(), vrEntity.getTag(), vrEntity.getDescription());
        vr.setId(vrEntity.getId());
        return vr;
    }
}

