/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.wf;

import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMSpringActionHandler;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.ExecutionContext;
import org.springframework.beans.factory.BeanFactory;

public class AVMReleaseTestServerHandler
extends JBPMSpringActionHandler {
    private SearchService searchService;
    private NodeService unprotectedNodeService;
    private static final String BEAN_NODE_SERVICE = "nodeService";
    private static final String BEAN_SEARCH_SERVICE = "searchService";
    private static final long serialVersionUID = -202652488887586866L;
    private static final Log logger = LogFactory.getLog(AVMReleaseTestServerHandler.class);

    @Override
    protected void initialiseHandler(BeanFactory factory) {
        this.searchService = (SearchService)factory.getBean(BEAN_SEARCH_SERVICE);
        this.unprotectedNodeService = (NodeService)factory.getBean(BEAN_NODE_SERVICE);
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        NodeRef testServer;
        NodeRef pkg = ((JBPMNode)executionContext.getContextInstance().getVariable("bpm_package")).getNodeRef();
        Pair<Integer, String> pkgPath = AVMNodeConverter.ToAVMVersionPath(pkg);
        String[] workflowStorePath = ((String)pkgPath.getSecond()).split(":");
        String workflowStoreName = workflowStorePath[0];
        JBPMNode webProjNode = (JBPMNode)executionContext.getContextInstance().getVariable("wcmwf_webproject");
        NodeRef webProjectRef = webProjNode.getNodeRef();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking for test server to release for store: " + workflowStoreName));
        }
        if ((testServer = this.findAllocatedServer(webProjectRef, workflowStoreName)) != null) {
            this.unprotectedNodeService.setProperty(testServer, WCMAppModel.PROP_DEPLOYSERVERALLOCATEDTO, null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Released test server '" + testServer + "' from store: " + workflowStoreName));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Store '" + workflowStoreName + "' didn't have an allocated test server to release"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeRef findAllocatedServer(NodeRef webProjectRef, String store) {
        StringBuilder query = new StringBuilder("@");
        query.append("wca");
        query.append("\\:");
        query.append(WCMAppModel.PROP_DEPLOYSERVERALLOCATEDTO.getLocalName());
        query.append(":\"");
        query.append(store);
        query.append("\"");
        NodeRef testServer = null;
        try (ResultSet results = null;){
            results = this.searchService.query(webProjectRef.getStoreRef(), "lucene", query.toString());
            if (results.length() == 1) {
                testServer = results.getNodeRef(0);
            } else if (results.length() > 1) {
                testServer = results.getNodeRef(0);
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("More than one allocated test server for store '" + store + "' was found, should only be one, first one found returned!"));
                }
            }
        }
        return testServer;
    }
}

