/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.wf;

import java.io.Serializable;
import java.util.List;
import java.util.SortedMap;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.avm.wf.AVMSubmitTransactionListener;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMSpringActionHandler;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.alfresco.wcm.util.WCMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.ExecutionContext;
import org.springframework.beans.factory.BeanFactory;

public class AVMSubmitPackageHandler
extends JBPMSpringActionHandler
implements Serializable {
    private static final long serialVersionUID = 4113360751217684995L;
    private static final Log logger = LogFactory.getLog(AVMSubmitPackageHandler.class);
    private AVMService fAVMService;
    private AVMSyncService fAVMSyncService;
    private AVMLockingService fAVMLockingService;
    private AVMSubmitTransactionListener fAVMSubmitTransactionListener;

    @Override
    protected void initialiseHandler(BeanFactory factory) {
        this.fAVMService = (AVMService)factory.getBean(ServiceRegistry.AVM_SERVICE.getLocalName());
        this.fAVMSyncService = (AVMSyncService)factory.getBean(ServiceRegistry.AVM_SYNC_SERVICE.getLocalName());
        this.fAVMLockingService = (AVMLockingService)factory.getBean(ServiceRegistry.AVM_LOCKING_SERVICE.getLocalName());
        this.fAVMSubmitTransactionListener = (AVMSubmitTransactionListener)factory.getBean("AVMSubmitTransactionListener");
        AlfrescoTransactionSupport.bindListener(this.fAVMSubmitTransactionListener);
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        NodeRef pkg = ((JBPMNode)executionContext.getContextInstance().getVariable("bpm_package")).getNodeRef();
        final Pair<Integer, String> pkgPath = AVMNodeConverter.ToAVMVersionPath(pkg);
        AVMNodeDescriptor pkgDesc = this.fAVMService.lookup((Integer)pkgPath.getFirst(), (String)pkgPath.getSecond());
        if (pkgDesc == null) {
            logger.warn((Object)("Submit skipped since workflow package does not exist: " + pkgPath));
        } else {
            final String from = (String)executionContext.getContextInstance().getVariable("wcmwf_fromPath");
            final String targetPath = pkgDesc.getIndirection();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("handling submit of " + (String)pkgPath.getSecond() + " from " + from + " to " + targetPath));
            }
            final String description = (String)executionContext.getContextInstance().getVariable("bpm_workflowDescription");
            final String tag = (String)executionContext.getContextInstance().getVariable("wcmwf_label");
            final String webProject = WCMUtil.getWebProject(this.fAVMService, AVMUtil.getStoreName(targetPath));
            final List<AVMDifference> stagingDiffs = this.fAVMSyncService.compare((Integer)pkgPath.getFirst(), (String)pkgPath.getSecond(), -1, targetPath, null);
            AlfrescoTransactionSupport.bindResource("staging_diffs", stagingDiffs);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    AVMSubmitPackageHandler.this.fAVMSyncService.update(stagingDiffs, null, false, false, true, true, tag, description);
                    AVMSubmitPackageHandler.this.fAVMSyncService.flatten((String)pkgPath.getSecond(), targetPath);
                    if (webProject != null) {
                        for (AVMDifference diff : stagingDiffs) {
                            AVMSubmitPackageHandler.this.recursivelyRemoveLocks(webProject, -1, diff.getSourcePath());
                        }
                    } else {
                        logger.warn((Object)("No webproject (hence no locks removed) for submit of " + (String)pkgPath.getSecond() + " from " + from + " to " + targetPath));
                    }
                    if (from != null && from.length() > 0) {
                        List<AVMDifference> sandboxDiffs = AVMSubmitPackageHandler.this.fAVMSyncService.compare((Integer)pkgPath.getFirst(), (String)pkgPath.getSecond(), -1, from, null);
                        AVMSubmitPackageHandler.this.fAVMSyncService.update(sandboxDiffs, null, true, true, false, false, tag, description);
                        AVMSubmitPackageHandler.this.fAVMSyncService.flatten(from, targetPath);
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    private void recursivelyRemoveLocks(String wpStoreId, int version, String wfPath) {
        AVMNodeDescriptor desc = this.fAVMService.lookup(version, wfPath, true);
        if (desc.isFile() || desc.isDeletedFile()) {
            String relativePath = WCMUtil.getStoreRelativePath(wfPath);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("removing file lock on " + relativePath + " (store id: " + wpStoreId + ")"));
            }
            this.fAVMLockingService.removeLock(wpStoreId, relativePath);
        } else if (!desc.isDeletedDirectory()) {
            SortedMap<String, AVMNodeDescriptor> list = this.fAVMService.getDirectoryListing(desc, true);
            for (AVMNodeDescriptor child : list.values()) {
                this.recursivelyRemoveLocks(wpStoreId, version, child.getPath());
            }
        }
    }
}

