/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.bulkimport.ImportableItem;

public class AnalysedDirectory {
    private List<File> originalListing = null;
    private Map<File, ImportableItem> importableItems = null;
    private Map<File, ImportableItem> importableDirectories = null;

    public AnalysedDirectory(File[] files) {
        this.originalListing = Arrays.asList(files);
        Collections.sort(this.originalListing);
        this.importableItems = new HashMap<File, ImportableItem>();
        this.importableDirectories = new HashMap<File, ImportableItem>();
    }

    public List<File> getOriginalListing() {
        return this.originalListing;
    }

    public Collection<ImportableItem> getImportableItems() {
        return this.importableItems.values();
    }

    public Collection<ImportableItem> getImportableDirectories() {
        return this.importableDirectories.values();
    }

    public void addImportableItem(ImportableItem importableItem) {
        if (importableItem.getHeadRevision().contentFileExists() && ImportableItem.FileType.DIRECTORY.equals((Object)importableItem.getHeadRevision().getContentFileType())) {
            this.importableDirectories.put(importableItem.getHeadRevision().getContentFile(), importableItem);
        } else {
            this.importableItems.put(importableItem.getHeadRevision().getContentFile(), importableItem);
        }
    }

    public ImportableItem findImportableItem(File contentFile) {
        ImportableItem result = null;
        result = this.importableItems.get(contentFile);
        if (result == null) {
            result = this.importableDirectories.get(contentFile);
        }
        return result;
    }
}

