/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.io.File;
import java.io.FileFilter;
import org.alfresco.repo.bulkimport.AnalysedDirectory;
import org.alfresco.repo.bulkimport.DirectoryAnalyser;
import org.alfresco.repo.bulkimport.FilesystemTracker;
import org.alfresco.repo.bulkimport.ImportableItem;
import org.alfresco.util.PropertyCheck;
import org.apache.log4j.Logger;

public abstract class AbstractFilesystemTracker
implements FilesystemTracker {
    protected static Logger logger = Logger.getLogger(FilesystemTracker.class);
    protected DirectoryAnalyser directoryAnalyser = null;

    public final void setDirectoryAnalyser(DirectoryAnalyser directoryAnalyser) {
        this.directoryAnalyser = directoryAnalyser;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"directoryAnalyser", (Object)this.directoryAnalyser);
    }

    protected final AnalysedDirectory getImportableItemsInDirectory(ImportableItem directory) {
        AnalysedDirectory analysedDirectory = this.directoryAnalyser.analyseDirectory(directory, null);
        return analysedDirectory;
    }

    protected final AnalysedDirectory getImportableDirectoriesInDirectory(ImportableItem directory, final int count) {
        FileFilter filter = null;
        filter = count != -1 ? new FileFilter(){
            private int i;
            {
                this.i = count;
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && this.i-- > 0;
            }
        } : new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        AnalysedDirectory analysedDirectory = this.directoryAnalyser.analyseDirectory(directory, filter);
        return analysedDirectory;
    }
}

