/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.bulkimport.BulkFilesystemImporter;
import org.alfresco.repo.bulkimport.BulkImportParameters;
import org.alfresco.repo.bulkimport.FilesystemTracker;
import org.alfresco.repo.bulkimport.ImportableItem;
import org.alfresco.repo.bulkimport.NodeImporter;
import org.alfresco.repo.bulkimport.impl.AbstractBulkFilesystemImporter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEventPublisher;

public abstract class MultiThreadedBulkFilesystemImporter
extends AbstractBulkFilesystemImporter {
    protected static final Log logger = LogFactory.getLog(BulkFilesystemImporter.class);
    protected int defaultBatchSize;
    protected int defaultNumThreads;
    protected int defaultLoggingInterval = 100;

    protected int getLoggingInterval(BulkImportParameters bulkImportParameters) {
        return bulkImportParameters.getLoggingInterval() != null ? bulkImportParameters.getLoggingInterval() : this.defaultLoggingInterval;
    }

    protected int getBatchSize(BulkImportParameters bulkImportParameters) {
        return bulkImportParameters.getBatchSize() != null ? bulkImportParameters.getBatchSize() : this.defaultBatchSize;
    }

    protected int getNumThreads(BulkImportParameters bulkImportParameters) {
        return bulkImportParameters.getNumThreads() != null ? bulkImportParameters.getNumThreads() : this.defaultNumThreads;
    }

    protected BatchProcessor.BatchProcessWorker<ImportableItem> getWorker(final BulkImportParameters bulkImportParameters, final String lockToken, final NodeImporter nodeImporter, final FilesystemTracker filesystemTracker) {
        final int batchSize = bulkImportParameters.getBatchSize() != null ? bulkImportParameters.getBatchSize() : this.defaultBatchSize;
        final boolean rulesEnabled = this.ruleService.isEnabled();
        final String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        final String currentDomain = TenantUtil.getCurrentDomain();
        BatchProcessor.BatchProcessWorker<ImportableItem> worker = new BatchProcessor.BatchProcessWorker<ImportableItem>(){

            @Override
            public String getIdentifier(ImportableItem importableItem) {
                return importableItem.toString();
            }

            @Override
            public void beforeProcess() throws Throwable {
                AuthenticationUtil.setRunAsUser((String)currentUser);
                MultiThreadedBulkFilesystemImporter.this.refreshLock(lockToken, (long)batchSize * 250L);
                if (bulkImportParameters.isDisableRulesService() && rulesEnabled) {
                    MultiThreadedBulkFilesystemImporter.this.ruleService.disableRules();
                }
            }

            @Override
            public void afterProcess() throws Throwable {
                if (bulkImportParameters.isDisableRulesService() && rulesEnabled) {
                    MultiThreadedBulkFilesystemImporter.this.ruleService.enableRules();
                }
                MultiThreadedBulkFilesystemImporter.this.importStatus.incrementNumberOfBatchesCompleted();
                AuthenticationUtil.clearCurrentSecurityContext();
            }

            @Override
            public void process(final ImportableItem importableItem) throws Throwable {
                if (MultiThreadedBulkFilesystemImporter.this.importStatus.getLastException() != null) {
                    return;
                }
                TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void doWork() throws Exception {
                        try {
                            MultiThreadedBulkFilesystemImporter.this.behaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
                            NodeRef nodeRef = nodeImporter.importImportableItem(importableItem, bulkImportParameters.isReplaceExisting());
                            filesystemTracker.itemImported(nodeRef, importableItem);
                        }
                        finally {
                            MultiThreadedBulkFilesystemImporter.this.behaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
                        }
                        return null;
                    }
                }, (String)currentUser, (String)currentDomain);
            }
        };
        return worker;
    }

    protected BatchProcessor<ImportableItem> getBatchProcessor(BulkImportParameters bulkImportParameters, BatchProcessWorkProvider<ImportableItem> workProvider, int loggingInterval) {
        int numThreads = this.getNumThreads(bulkImportParameters);
        int batchSize = this.getBatchSize(bulkImportParameters);
        this.importStatus.setNumThreads(numThreads);
        this.importStatus.setBatchSize(batchSize);
        BatchProcessor<ImportableItem> batchProcessor = new BatchProcessor<ImportableItem>("Bulk Filesystem Import", this.transactionHelper, workProvider, numThreads, batchSize, (ApplicationEventPublisher)this.applicationContext, logger, loggingInterval);
        return batchProcessor;
    }

    public void setDefaultNumThreads(int defaultNumThreads) {
        this.defaultNumThreads = defaultNumThreads;
    }

    public void setDefaultBatchSize(int defaultBatchSize) {
        this.defaultBatchSize = defaultBatchSize;
    }

    public int getDefaultNumThreads() {
        return this.defaultNumThreads;
    }

    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    @Override
    protected void bulkImportImpl(BulkImportParameters bulkImportParameters, NodeImporter nodeImporter, String lockToken) {
        int batchSize = this.getBatchSize(bulkImportParameters);
        int numThreads = this.getNumThreads(bulkImportParameters);
        this.importStatus.setNumThreads(numThreads);
        this.importStatus.setBatchSize(batchSize);
    }
}

